from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.PresetListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_filter_form/?$',
        views.PresetFilterFormView.as_view(),
        name='filter-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.PresetView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/problems/(?P<problem_id>\d+)/?$',
        views.PresetProblemView.as_view(),
        name='problem',
    ),
    url(
        r'^(?P<pk>\d+)/reorder/?$',
        views.PresetReorderView.as_view(),
        name='reorder',
    ),
    url(
        r'^(?P<pk>\d+)/add_problems_from_preset/?$',
        views.PresetAddProblemsFromPresetView.as_view(),
        name='add-problems-from-preset',
    ),
]
