from django.conf.urls import url, include
from django.urls import path
from django.views.decorators.csrf import csrf_exempt
from drf_yasg import openapi
from drf_yasg.views import get_schema_view

from intranet.femida.src.api.candidates import views as candidate_views
from intranet.femida.src.api.communications import views as communication_views
from intranet.femida.src.api.forms_constructor import views as forms_constructor_views
from intranet.femida.src.api.isearch import views as isearch_views
from intranet.femida.src.api.offers import views as offer_views
from intranet.femida.src.api.preprofiles import views as preprofile_views
from intranet.femida.src.api.rotations import views as rotation_views
from intranet.femida.src.api.vacancies import views as vacancy_views
from intranet.femida.src.api.views import ServiceInfoView, ServicePermissionsYamlView

urlpatterns = []

urlpatterns += [
    url(r'^swagger/$', get_schema_view(
        openapi.Info(title='Femida Api', default_version='v1'),
        public=True,
        urlconf='intranet.femida.src.api.private_urls'
    ).with_ui())
]

urlpatterns += [
    path(
        'service_permissions.yaml',
        ServicePermissionsYamlView.as_view(),
        name='service-permissions-yaml',
    ),

    # FORMS CONSTRUCTOR INTEGRATION
    url(
        r'^forms/submissions/?$',
        csrf_exempt(forms_constructor_views.FormsConstructorSubmissionView.as_view()),
        name='forms-constructor-integration',
    ),
    url(
        r'^forms/aa_entry/?$',
        forms_constructor_views.FormsConstructorAAEntryView.as_view(),
        name='forms-aa-entry',
    ),
    url(
        r'^forms/verifications/?$',
        forms_constructor_views.FormsConstructorVerificationView.as_view(),
        name='forms-verification',
    ),
    url(
        r'^forms/verifications/success/?$',
        forms_constructor_views.FormsConstructorVerificationSuccessView.as_view(),
        name='forms-verification-success',
    ),
    url(
        r'^forms/verifications/ess_check/?$',
        forms_constructor_views.FormsConstructorVerificationEssCheckView.as_view(),
        name='forms-verification-ess-check',
    ),

    # SEPARATOR
    url(
        r'^separator/identify/?$',
        csrf_exempt(communication_views.SeparatorIdentifyCandidateView.as_view()),
        name='separator-identify-candidate',
    ),

    url(
        r'^separator/create/?$',
        csrf_exempt(communication_views.SeparatorCreateMessageView.as_view()),
        name='separator-create-message',
    ),

    # ISEARCH
    url(
        r'^isearch/candidates/?$',
        isearch_views.CandidateListView.as_view(),
        name='isearch-candidate-list',
    ),
    url(
        r'^isearch/candidates/(?P<pk>\d+)/?$',
        isearch_views.CandidateDetailView.as_view(),
        name='isearch-candidate-detail',
    ),
    url(
        r'^isearch/candidates/acl/?$',
        isearch_views.CandidateACLView.as_view(),
        name='isearch-candidate-acl',
    ),

    # PREPROFILE
    url(
        r'^newhire/preprofiles/?$',
        csrf_exempt(preprofile_views.PreprofileCreateView.as_view()),
        name='preprofiles',
    ),

    # STARTREK
    url(
        r'^tracker/vacancies/close_by_issue/?$',
        vacancy_views.VacancyCloseByIssueView.as_view(),
        name='tracker-vacancy-close-by-issue',
    ),
    url(
        r'^tracker/vacancies/change_type_by_issue/?$',
        vacancy_views.VacancyChangeTypeByIssueView.as_view(),
        name='tracker-vacancy-change-type-by-issue',
    ),
    url(
        r'^tracker/vacancies/approve_by_issue/?$',
        vacancy_views.VacancyApproveByIssueView.as_view(),
        name='tracker-vacancy-approve-by-issue',
    ),
    url(
        r'^tracker/vacancies/approve_bp_by_issue/?$',
        vacancy_views.VacancyApproveBPByIssueView.as_view(),
        name='tracker-vacancy-approve-bp-by-issue',
    ),
    url(
        r'^tracker/offers/approve_by_issue/?$',
        offer_views.OfferApproveByIssueView.as_view(),
        name='tracker-offer-approve-by-issue',
    ),
    url(
        r'^tracker/offers/confirm_by_issue/?$',
        offer_views.OfferConfirmByIssueView.as_view(),
        name='tracker-offer-confirm-by-issue',
    ),
    url(
        r'^tracker/offers/confirm_by_current_team/?$',
        offer_views.OfferConfirmByCurrentTeamView.as_view(),
        name='tracker-offer-confirm-by-current-team',
    ),
    url(
        r'^tracker/offers/decline_by_issue/?$',
        offer_views.OfferDeclineByIssueView.as_view(),
        name='tracker-offer-decline-by-issue',
    ),
    url(
        r'^tracker/rotations/approve/?$',
        rotation_views.RotationApproveView.as_view(),
        name='tracker-rotation-approve',
    ),
    url(
        r'^tracker/rotations/reject/?$',
        rotation_views.RotationRejectView.as_view(),
        name='tracker-rotation-reject',
    ),
    url(
        r'^tracker/verifications/resolve/?$',
        candidate_views.VerificationResolutionView.as_view(),
        name='tracker-verification-resolve',
    ),

    # STAFF
    url(
        r'^staff/vacancies/?$',
        vacancy_views.StaffVacancyListView.as_view(),
        name='staff-vacancy-list',
    ),
    path(
        'staff/vacancies/<int:pk>/change_department/',
        vacancy_views.StaffVacancyUpdateView.as_view(),
        name='staff-vacancy-update-department',
    ),
    path(
        'staff/vacancies/<int:pk>/',
        vacancy_views.StaffVacancyUpdateView.as_view(),
        name='staff-vacancy-update',
    ),
    path(
        'staff/vacancies/<int:pk>/create_bp/',
        vacancy_views.StaffVacancyBPCreatedView.as_view(),
        name='staff-vacancy-bp-created',
    ),
    path(
        'staff/vacancies/<int:pk>/close/',
        vacancy_views.StaffVacancyCloseView.as_view(),
        name='staff-vacancy-close',
    ),

    # YT/YANG
    url(
        r'^yt/candidates/bulk_upload/?$',
        candidate_views.YTCandidateBulkUploadView.as_view(),
        name='yt-candidate-bulk-upload',
    ),

    url(
        r'^yt/candidate_scorings/bulk_upload?$',
        candidate_views.YTCandidateScoringBulkUploadView.as_view(),
        name='yt-candidate-scorings-bulk-upload',
    ),

    # TODO: ссылка yang остаётся пока для обратной совместимости,
    #  в идеале, они тоже перейдут на ручку yt/
    url(
        r'^yang/candidates/bulk_upload/?$',
        candidate_views.YTCandidateBulkUploadView.as_view(),
        name='yang-candidate-bulk-upload',
    ),

    # MAGICLINKS
    url(
        r'^magiclinks/candidates/?$',
        candidate_views.MagicLinksCandidateListView.as_view(),
        name='magiclinks-candidate-list',
    ),

    # MONITORING
    url(r'^monitoring/', include(('intranet.femida.src.api.monitoring.urls', 'monitoring'))),

    # HIRE ORDERS
    url(r'^hire_orders/', include(('intranet.femida.src.api.hire_orders.urls', 'hire_orders'))),

    # FRONTEND
    url(r'^frontend/', include(('intranet.femida.src.api.frontend.urls', 'frontend'))),

    # FRONTBACK
    url(r'^frontback/serviceinfo/?$', ServiceInfoView.as_view()),

    # Сайт Вакансий
    url(
        r'^jobs/publications/',
        include(('intranet.femida.src.api.publications.external.urls', 'publications')),
    ),
    url(
        r'^jobs/services/',
        include(('intranet.femida.src.api.services.urls', 'services')),
    ),
    url(
        r'^jobs/professions/',
        include(('intranet.femida.src.api.professions.urls', 'professions')),
    ),
    url(
        r'^jobs/public_professions/',
        include(
            ('intranet.femida.src.api.public_professions.urls', 'public_professions'),
            namespace='public-professions',
        ),
    ),
    url(
        r'^jobs/cities/',
        include(('intranet.femida.src.api.cities.urls', 'cities')),
    ),
    url(
        r'^jobs/certifications/',
        include(('intranet.femida.src.api.certifications.urls', 'certifications')),
    ),
    url(
        r'^jobs/suggest/',
        include(('intranet.femida.src.api.jobs.suggest.urls', 'jobs_suggest')),
    ),
]
