import sform

from intranet.femida.src.api.core.forms import (
    CategoryModelMultipleChoiceField,
    InterviewSuggestField,
    PresetSuggestField,
    SortField,
    UserSuggestField,
    ProblemSuggestField,
)
from intranet.femida.src.problems import choices


class ProblemCreateForm(sform.SForm):

    summary = sform.CharField(state=sform.REQUIRED)
    description = sform.CharField(state=sform.REQUIRED)
    solution = sform.CharField()
    categories = CategoryModelMultipleChoiceField(state=sform.REQUIRED)


class ProblemUpdateForm(ProblemCreateForm):

    is_deprecated = sform.BooleanField()


class ProblemSearchForm(sform.SForm):

    text = sform.CharField()
    only_favorite = sform.BooleanField()
    categories = CategoryModelMultipleChoiceField()
    created_by = UserSuggestField()
    exclude_deprecated = sform.BooleanField()
    preset = PresetSuggestField()
    sort = SortField(
        choices=choices.PROBLEM_SORTING_TYPES,
        default='-rank',
    )


class ProblemListFilterForm(sform.SForm):

    # фильтры
    used_for_interview = sform.NullBooleanField(default=None)
    used_for_another_interview = sform.NullBooleanField(default=None)
    used_for_candidate = sform.NullBooleanField(default=None)
    used_for_preset = sform.NullBooleanField(default=None)

    # контекст
    for_interview = InterviewSuggestField()
    for_preset = PresetSuggestField()

    def get_field_state(self, name):
        if name == 'for_interview':
            return (
                self.cleaned_data.get('used_for_interview') is not None
                or self.cleaned_data.get('used_for_candidate') is not None
                or self.cleaned_data.get('used_for_another_interview') is not None
            )
        elif name == 'for_preset':
            return self.cleaned_data.get('used_for_preset') is not None

        return super().get_field_state(name)


class ProblemMergeForm(sform.SForm):
    # TODO: Убрать _id из названий полей
    problem_id = ProblemSuggestField()
    original_problem_id = ProblemSuggestField()
