from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.ProblemCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_form/?$',
        views.ProblemCreateView.as_form_view(),
        name='create-form',
    ),
    url(
        r'^search/?$',
        views.ProblemsSearchView.as_view(),
        name='search',
    ),
    url(
        r'^search/_form/?$',
        views.ProblemsSearchFormView.as_view(),
        name='search-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.ProblemDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.ProblemDetailView.as_form_view(),
        name='update-form',
    ),
    url(
        r'^(?P<pk>\d+)/merge/?$',
        views.ProblemMergeView.as_view(),
        name='merge',
    ),
    url(
        r'^(?P<pk>\d+)/assignments/?$',
        views.ProblemAssignments.as_view(),
        name='assignments',
    ),
]
