from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer, AwareSerializerMixin
from intranet.femida.src.professions.models import ProfessionalSphere, Profession


class ProfessionalSphereSerializer(serializers.ModelSerializer):

    name = serializers.ReadOnlyField(source='localized_name')
    description = serializers.ReadOnlyField()

    class Meta:
        model = ProfessionalSphere
        fields = (
            'id',
            'slug',
            'name',
            'description',
            'position',
            'is_active',
        )


class ProfessionLiteSerializer(FemidaSerializer):

    name = serializers.ReadOnlyField(source='localized_name')
    professional_sphere = ProfessionalSphereSerializer()

    class Meta:
        model = Profession
        fields = ('id', 'name', 'position', 'is_active', 'professional_sphere')


class ProfessionSerializer(AwareSerializerMixin, ProfessionLiteSerializer):

    publications_count = serializers.SerializerMethodField()

    def get_publications_count(self, obj):
        if 'publications_count_by_profession_id' not in self.root.context:
            return None
        publications_count_data = self.root.context['publications_count_by_profession_id']
        return publications_count_data.get(obj.id, 0)

    class Meta(ProfessionLiteSerializer.Meta):
        fields = ProfessionLiteSerializer.Meta.fields + ('slug', 'publications_count')

        select_related_map = {
            'professional_sphere': ('professional_sphere',),
        }
