from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer, AwareSerializerMixin
from intranet.femida.src.jobs.public_professions.models import (
    PublicProfession,
    PublicProfessionalSphere,
)


class PublicProfessionalSphereSerializer(serializers.ModelSerializer):

    name = serializers.ReadOnlyField()
    description = serializers.ReadOnlyField()

    class Meta:
        model = PublicProfessionalSphere
        fields = (
            'id',
            'slug',
            'name',
            'description',
            'position',
        )


class PublicProfessionSerializer(AwareSerializerMixin, FemidaSerializer):

    name = serializers.ReadOnlyField()
    professional_sphere = PublicProfessionalSphereSerializer(source='public_professional_sphere')
    publications_count = serializers.SerializerMethodField()

    def get_publications_count(self, obj):
        if 'publications_count_by_public_profession_id' not in self.root.context:
            return None
        publications_count_data = self.root.context['publications_count_by_public_profession_id']
        return publications_count_data.get(obj.id, 0)

    class Meta:
        model = PublicProfession

        fields = (
            'id',
            'is_active',
            'name',
            'position',
            'professional_sphere',
            'publications_count',
            'slug',
        )

        select_related_map = {
            'professional_sphere': ('public_professional_sphere',),
        }
