import waffle

from rest_framework import permissions


class PublicationPermission(permissions.BasePermission):

    def has_permission(self, request, view):
        if not waffle.switch_is_active('enable_publication_restriction'):
            return True
        return request.user.has_perm('permissions.can_see_publications')


class PublicationSubscriptionPermission(PublicationPermission):

    def has_object_permission(self, request, view, obj):
        return request.user == obj.created_by
