from django.conf.urls import url
from django.urls import path

from . import views


urlpatterns = [
    url(
        r'^$',
        views.InternalPublicationListView.as_view(),
        name='list',
    ),
    url(
        r'^_filter_form/?$',
        views.InternalPublicationListFilterFormView.as_form_view(),
        name='filter-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.InternalPublicationDetailView.as_view(),
        name='internal-detail',
    ),
    url(
        r'^subscriptions/?$',
        views.PublicationSubscriptionListCreateView.as_view(),
        name='publication-subscription-list',
    ),
    url(
        r'^subscriptions/(?P<pk>\d+)/?$',
        views.PublicationSubscriptionDetailView.as_view(),
        name='publication-subscription-detail',
    ),
    path(
        '<uuid:uuid>/',
        views.PublicationDetailView.as_view(),
        name='detail',
    ),
]
