import sform

from intranet.femida.src.api.core.fetchers import query_params_data_getter
from intranet.femida.src.api.core.forms import (
    AttachmentMultipleSuggestField,
    PublicationMultipleSuggestField,
    BooleanField,
)
from intranet.femida.src.api.core.validators import validate_phone


class ReferenceForm(sform.SForm):

    default_getter = query_params_data_getter

    first_name = sform.CharField(max_length=255, state=sform.REQUIRED)
    last_name = sform.CharField(max_length=255, state=sform.REQUIRED)
    email = sform.EmailField(max_length=255, state=sform.REQUIRED)
    phone = sform.CharField(
        max_length=64,
        validators=[validate_phone],
    )
    comment = sform.CharField(state=sform.REQUIRED)
    attachments = AttachmentMultipleSuggestField(max_files=1)
    is_candidate_informed = BooleanField(state=sform.REQUIRED)
    publications = PublicationMultipleSuggestField(state=sform.REQUIRED)
