import logging

from django.contrib.auth import get_user_model

from intranet.femida.src.actionlog.decorators import action_logged
from intranet.femida.src.candidates.references.controllers import create_reference
from intranet.femida.src.candidates.models import Reference
from intranet.femida.src.api.core.views import (
    unfold_query_params,
    BaseFormViewMixin,
    BaseView,
)
from intranet.femida.src.api.publications.permissions import PublicationPermission
from intranet.femida.src.api.references import forms, serializers


User = get_user_model()


logger = logging.getLogger(__name__)


class ReferenceCreateView(BaseFormViewMixin, BaseView):

    model_class = Reference
    validator_class = forms.ReferenceForm
    detail_serializer_class = serializers.ReferenceSerializer
    permission_classes = [PublicationPermission]

    @action_logged('reference_create')
    def post(self, request, *args, **kwargs):
        return self.create(request, *args, **kwargs)

    def get_initial_data(self):
        return unfold_query_params(
            query_params=self.request.query_params,
            list_fields=('publications',),
        )

    def perform_create(self, data):
        return create_reference(
            data=data,
            initiator=self.request.user,
        )
