import sform

from intranet.femida.src.api.core.forms import ReminderMessageSuggestField
from intranet.femida.src.communications.validators import validate_future_time


class ReminderUpdateForm(sform.SForm):
    """
    Форма редактирования напоминания на заметке
    """
    remind_at = sform.DateTimeField(
        state=sform.REQUIRED,
        validators=[validate_future_time],
    )


class ReminderCreateForm(ReminderUpdateForm):
    """
    Форма создания напоминания на заметке
    """
    message = ReminderMessageSuggestField(state=sform.REQUIRED)
