from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer, WorkflowActionsField
from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.communications.models import Message, Reminder
from intranet.femida.src.communications.workflow import NoteWorkflow


class NoteForReminderSerializer(FemidaSerializer):

    actions = WorkflowActionsField(NoteWorkflow)

    class Meta:
        model = Message
        fields = (
            'id',
            'actions',
        )


class ReminderSerializer(serializers.ModelSerializer):

    user = UserSerializer()

    class Meta:
        model = Reminder
        fields = (
            'id',
            'remind_at',
            'user',
            'status',
            'message',
        )


class ReminderCreateSerializer(ReminderSerializer):

    message = NoteForReminderSerializer()
