import sform
from django.core.exceptions import ValidationError

from intranet.femida.src.api.core.fetchers import query_params_data_getter
from intranet.femida.src.api.core.forms import (
    EMPTY_LABEL,
    BooleanField,
    PublicationMultipleSuggestField,
    BaseMetaForm,
)
from intranet.femida.src.candidates import choices
from intranet.femida.src.candidates.rotations.helpers import (
    get_current_rotation,
    is_user_rotating,
    user_has_active_consideration,
)


class RotationForm(BaseMetaForm):

    default_getter = query_params_data_getter

    reason = sform.ChoiceField(
        state=sform.REQUIRED,
        empty_label=EMPTY_LABEL,
        choices=choices.ROTATION_REASONS,
    )
    publications = PublicationMultipleSuggestField(state=sform.REQUIRED)
    comment = sform.CharField()  # коммент для НМ-ов

    is_agree = BooleanField(state=sform.REQUIRED)
    is_privacy_needed = BooleanField()

    def clean(self):
        cd = super().clean()
        if is_user_rotating(self.context['user']):
            raise ValidationError('already_rotating')
        return cd

    def meta_as_dict(self):
        user = self.context['user']
        current_rotation = get_current_rotation(user)
        return {
            'is_rotating': current_rotation is not None or user_has_active_consideration(user),
            'startrek_rotation_key': getattr(current_rotation, 'startrek_rotation_key', None),
            'startrek_myrotation_key': getattr(current_rotation, 'startrek_myrotation_key', None),
        }
