from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer, IdSlugNameSerializer
from intranet.femida.src.publications.helpers import get_publications_lang
from intranet.femida.src.services.models import PublicService


class PublicServiceLiteSerializer(FemidaSerializer):

    name = serializers.ReadOnlyField()
    description = serializers.ReadOnlyField()

    class Meta:
        model = PublicService
        fields = (
            'id',
            'icon',
            'name',
            'description',
            'slug',
            'is_active',
        )


class PublicServiceSerializer(PublicServiceLiteSerializer):

    publications_count = serializers.IntegerField()
    cities = serializers.SerializerMethodField()

    def get_cities(self, obj):
        lang = get_publications_lang()
        cities = self.root.context.get('city_by_id', {})
        city_ids_by_service = self.root.context.get('city_ids_by_service', {})

        city_ids = city_ids_by_service.get(obj.id, [])

        cities_data = IdSlugNameSerializer(
            [cities[pk] for pk in city_ids if pk],
            many=True,
            name_source=f'name_{lang}',
        ).data

        for city in cities_data:
            city['priority'] = self.get_city_priority(city['id'], obj.id)

        return cities_data

    def get_city_priority(self, city_id, public_service_id):
        publication_counts = self.root.context.get('publications_count_by_city_service', {})
        return publication_counts.get((city_id, public_service_id), 0)

    class Meta(PublicServiceLiteSerializer.Meta):
        fields = PublicServiceLiteSerializer.Meta.fields + ('publications_count', 'cities')
