from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer
from intranet.femida.src.staff.models import Office, Department, Service


class OfficeSerializer(FemidaSerializer):

    name = serializers.ReadOnlyField()
    address = serializers.ReadOnlyField()

    class Meta:
        model = Office
        fields = (
            'id',
            'name',
            'address',
        )


class DepartmentSerializer(FemidaSerializer):

    name = serializers.ReadOnlyField(source='localized_name')

    class Meta:
        model = Department
        fields = '__all__'


class ServiceSerializer(FemidaSerializer):

    class Meta:
        model = Service
        fields = '__all__'
