from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^applications/?$',
        views.ApplicationsStatsView.as_view(),
        name='applications-stats',
    ),
    url(
        r'^interviews/?$',
        views.InterviewsStatsView.as_view(),
        name='interviews-stats',
    ),
    url(
        r'^problems/?$',
        views.ProblemsStatsView.as_view(),
        name='problems-stats',
    ),
    url(
        r'^assignments/?$',
        views.AssignmentsStatsView.as_view(),
        name='assignments-stats',
    ),
    url(
        r'^users/(?P<username>\w+)/?$',
        views.UserStatsView.as_view(),
        name='user-stats',
    ),
]
