from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.SubmissionListFilterFormView.as_view(),
        name='list',
    ),
    url(
        r'^_filter_form/?$',
        views.SubmissionListFilterFormView.as_form_view(),
        name='filter-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.SubmissionDetailView.as_view(),
        name='detail',
    ),

    url(
        r'^(?P<pk>\d+)/handle/?$',
        views.SubmissionHandleView.as_view(),
        name='handle',
    ),
    url(
        r'^(?P<pk>\d+)/handle/_form/?$',
        views.SubmissionHandleView.as_form_view(),
        name='handle-form',
    ),
    url(
        r'^(?P<pk>\d+)/reject/?$',
        views.SubmissionRejectView.as_view(),
        name='reject',  # спам: закрытие без обработки
    ),

    url(
        r'^(?P<pk>\d+)/approve_reference/?$',
        views.ReferenceApproveView.as_view(),
        name='approve-reference',
    ),
    url(
        r'^(?P<pk>\d+)/approve_reference/_form/?$',
        views.ReferenceApproveView.as_form_view(),
        name='approve-reference-form',
    ),
    url(
        r'^(?P<pk>\d+)/approve_reference_without_benefits/?$',
        views.ReferenceApproveWithoutBenefitsView.as_view(),
        name='approve-reference-without-benefits',
    ),
    url(
        r'^(?P<pk>\d+)/approve_reference_without_benefits/_form/?$',
        views.ReferenceApproveWithoutBenefitsView.as_form_view(),
        name='approve-reference-without-benefits-form',
    ),
    url(
        r'^(?P<pk>\d+)/reject_reference/?$',
        views.ReferenceRejectView.as_view(),
        name='reject-reference',
    ),
    url(
        r'^(?P<pk>\d+)/reject_reference/_form/?$',
        views.ReferenceRejectView.as_form_view(),
        name='reject-reference-form',
    ),
]
