from intranet.femida.src.api.communications.serializers import MessageTemplateSerializer
from intranet.femida.src.api.core.views import BaseView
from intranet.femida.src.communications.models import MessageTemplate


class TemplateListVew(BaseView):

    model_class = MessageTemplate
    list_item_serializer_class = MessageTemplateSerializer

    def filter_queryset(self, queryset):
        template_type = self.request.query_params.get('type')
        if template_type:
            queryset = queryset.filter(type=template_type)
        return (
            queryset
            .filter(is_active=True)
            .order_by('name')
        )

    def get(self, request, *args, **kwargs):
        """
        Список текстовых шаблонов
        """
        return self.list(request, *args, **kwargs)
