from django.conf.urls import include, url
from django.views.decorators.csrf import ensure_csrf_cookie
from drf_yasg import openapi
from drf_yasg.views import get_schema_view

from intranet.femida.src.api.interviews import views as interview_views
from intranet.femida.src.api.views import MetaView
from intranet.femida.src.api.schemas import FemidaSchemaGenerator

urlpatterns = []

urlpatterns += [
    url(r'^swagger/$', get_schema_view(
        openapi.Info(title='Femida Api', default_version='v1'),
        public=True,
        urlconf='intranet.femida.src.api.urls',
        generator_class=FemidaSchemaGenerator
    ).with_ui())
]

urlpatterns += [
    url(r'', include(('intranet.femida.src.api.communications.urls', 'communications'))),
    url(r'', include(('intranet.femida.src.api.users.urls', 'users'))),
    url(r'', include(('intranet.femida.src.api.attachments.urls', 'attachments'))),

    url(r'^applications/', include(('intranet.femida.src.api.applications.urls', 'applications'))),
    url(r'^complaints/', include(('intranet.femida.src.api.complaints.urls', 'complaints'))),
    url(r'^candidates/', include(('intranet.femida.src.api.candidates.urls', 'candidates'))),
    url(r'^challenges/', include(('intranet.femida.src.api.challenges.urls', 'challenges'))),
    url(r'^comments/', include(('intranet.femida.src.api.comments.urls', 'comments'))),
    url(
        r'^considerations/',
        include(('intranet.femida.src.api.considerations.urls', 'considerations')),
    ),
    url(r'^duplication_cases/',
        include(
            ('intranet.femida.src.api.duplication_cases.urls', 'duplication_cases'),
            namespace='duplication-cases',
        )),
    url(r'^interviews/', include(('intranet.femida.src.api.interviews.urls', 'interviews'))),
    url(
        r'^interview_rounds/',
        include(
            ('intranet.femida.src.api.interview_rounds.urls', 'interview_rounds'),
            namespace='interview-rounds',
        )),
    # TODO: Объединить assignments и assignments-new
    url(r'^interviews/(?P<interview_id>\d+)/assignments/',
        include(('intranet.femida.src.api.assignments.urls', 'assignments'))),
    url(
        r'^assignments/',
        include(
            ('intranet.femida.src.api.assignments.urls', 'assignments'),
            namespace='assignments-new',
        ),
    ),
    url(r'^log/', include(('intranet.femida.src.api.actionlog.urls', 'actionlog'))),
    url(r'^oebs/', include(('intranet.femida.src.api.oebs.urls', 'oebs'))),
    url(r'^offers/', include(('intranet.femida.src.api.offers.urls', 'offers'))),
    url(r'^presets/', include(('intranet.femida.src.api.presets.urls', 'presets'))),
    url(r'^problems/', include(('intranet.femida.src.api.problems.urls', 'problems'))),
    url(r'^categories/', include(('intranet.femida.src.api.categories.urls', 'categories'))),
    url(r'^stats/', include(('intranet.femida.src.api.stats.urls', 'stats'))),
    url(r'^submissions/', include(('intranet.femida.src.api.submissions.urls', 'submissions'))),
    url(r'^references/', include(('intranet.femida.src.api.references.urls', 'references'))),
    url(r'^rotations/', include(('intranet.femida.src.api.rotations.urls', 'rotations'))),
    url(r'^suggest/', include(('intranet.femida.src.api.suggest.urls', 'suggest'))),
    url(r'^templates/', include(('intranet.femida.src.api.text_templates.urls', 'templates'))),
    url(r'^vacancies/', include(('intranet.femida.src.api.vacancies.urls', 'vacancies'))),
    url(
        r'^vacancy_groups/',
        include(
            ('intranet.femida.src.api.vacancy_groups.urls', 'vacancy_groups'),
            namespace='vacancy-groups',
        ),
    ),
    url(r'^publications/', include(('intranet.femida.src.api.publications.urls', 'publications'))),
    url(r'^hh/', include(('intranet.femida.src.api.hh.urls', 'hh'))),
    url(
        r'^_meta/?$',
        ensure_csrf_cookie(MetaView.as_view()),
        name='meta',
    ),
    url(
        r'^calendar/events/(?P<event_id>\d+)/?$',
        interview_views.InterviewEventView.as_view(),
        name='calendar-event',
    ),
    url(r'^reminders/', include(('intranet.femida.src.api.reminders.urls', 'reminders'))),
]
