import sform
from django.core.exceptions import ValidationError

from intranet.femida.src.api.core.forms import (
    VacancySuggestField,
    UserSuggestField,
)
from intranet.femida.src.interviews.choices import AA_TYPES


class InterviewerListFilterForm(sform.SForm):

    vacancy = VacancySuggestField()
    user = UserSuggestField()
    aa_type = sform.ChoiceField(choices=AA_TYPES)

    def clean(self):
        cleaned_data = super().clean()
        required_fields = (
            'vacancy',
            'user',
            'aa_type',
        )

        field_values = [cleaned_data.get(f) for f in required_fields]
        if not any(field_values):
            raise ValidationError(
                message='Specify one of required fields: {}'.format(', '.join(required_fields)),
                code='missing_vacancy_user_aa_type',
            )
        elif sum(bool(value) for value in field_values) > 1:
            raise ValidationError(
                message='Specify only one of fields: {}'.format(', '.join(required_fields)),
                code='redundant_query_params',
            )

        return cleaned_data
