from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.VacancyListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_filter_form/?$',
        views.VacancyListFilterFormView.as_view(),
        name='filter-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.VacancyDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/stats/?$',
        views.VacancyStatsView.as_view(),
        name='stats',
    ),
    url(
        r'^_form/?$',
        views.VacancyCreateFormView.as_view(),
        name='create-form',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.VacancyDetailView.as_form_view(),
        name='update-form',
    ),
    url(
        r'^(?P<pk>\d+)/approve/?$',
        views.VacancyApproveView.as_view(),
        name='approve',
    ),
    url(
        r'^(?P<pk>\d+)/approve/_form/?$',
        views.VacancyApproveView.as_form_view(),
        name='approve-form',
    ),
    url(
        r'^(?P<pk>\d+)/add_to_group/?$',
        views.VacancyAddToGroupView.as_view(),
        name='add-to-group',
    ),
    url(
        r'^(?P<pk>\d+)/add_to_group/_form/?$',
        views.VacancyAddToGroupView.as_form_view(),
        name='add-to-group-form',
    ),
    url(
        r'^(?P<pk>\d+)/suspend/?$',
        views.VacancySuspendView.as_view(),
        name='suspend',
    ),
    url(
        r'^(?P<pk>\d+)/suspend/_form/?$',
        views.VacancySuspendView.as_form_view(),
        name='suspend-form',
    ),
    url(
        r'^(?P<pk>\d+)/resume/?$',
        views.VacancyResumeView.as_view(),
        name='resume',
    ),
    url(
        r'^(?P<pk>\d+)/resume/_form/?$',
        views.VacancyResumeView.as_form_view(),
        name='resume-form',
    ),
    url(
        r'^(?P<pk>\d+)/close/?$',
        views.VacancyCloseView.as_view(),
        name='close',
    ),
    url(
        r'^(?P<pk>\d+)/close/_form/?$',
        views.VacancyCloseView.as_form_view(),
        name='close-form',
    ),
]
