import sform

from intranet.femida.src.api.core.forms import (
    UserMultipleSuggestField,
    VacancyMultipleSuggestField,
    validate_recruiters,
)


class VacancyGroupForm(sform.SForm):

    is_active = sform.BooleanField(default=True, state=sform.REQUIRED)
    name = sform.CharField(
        max_length=255,
        state=sform.REQUIRED,
    )
    description = sform.CharField()
    recruiters = UserMultipleSuggestField(state=sform.REQUIRED)
    vacancies = VacancyMultipleSuggestField(state=sform.REQUIRED)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        assert 'user' in self.context
        self.user = self.context['user']

        # По умолчанию добавляем пользователя в рекрутеры
        initial = kwargs.pop('initial', {})
        if 'recruiters' not in initial or not initial['recruiters']:
            initial['recruiters'] = [self.user.username]

        kwargs['initial'] = initial
        super().__init__(*args, **kwargs)

    def clean_recruiters(self, recruiters):
        validate_recruiters(recruiters)
        return recruiters
