from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.VacancyGroupListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.VacancyGroupDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^_form/?$',
        views.VacancyGroupListCreateView.as_form_view(),
        name='create-form',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.VacancyGroupDetailView.as_form_view(),
        name='update-form',
    ),

    # workflow

    url(
        r'^(?P<pk>\d+)/activate/?$',
        views.VacancyGroupActivateView.as_view(),
        name='activate',
    ),
    url(
        r'^(?P<pk>\d+)/deactivate/?$',
        views.VacancyGroupDeactivateView.as_view(),
        name='deactivate',
    ),
]
