from django.contrib import admin

from . import models


class ApplicationAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'candidate',
        'vacancy',
        'consideration',
        'created_by',
        'submission',
    )

    search_fields = (
        'id',
        'vacancy__id',
        'candidate__id',
    )

    list_display = (
        'id',
        'candidate',
        'vacancy',
        'status',
        'resolution',
        'source',
        'proposal_factors',
    )

    list_filter = (
        'status',
        'resolution',
        'source',
    )


admin.site.register(models.Application, ApplicationAdmin)
