from django.db import connection


class ApplicationConsiderationTmpTable:

    name = 'application_consideration_tmp'

    @classmethod
    def _execute_raw_sql(cls, raw_sql):
        cursor = connection.cursor()
        cursor.execute(raw_sql.format(
            table_name=cls.name,
        ))

    @classmethod
    def _create(cls):
        cls._execute_raw_sql(
            'CREATE TABLE {table_name} '
            '(application_id INT, consideration_id INT)'
        )

    @classmethod
    def _drop(cls):
        cls._execute_raw_sql(
            'DROP TABLE {table_name}'
        )

    @classmethod
    def _update_applications(cls):
        cls._execute_raw_sql(
            'UPDATE interviews_application as T1 '
            'SET consideration_id = T2.consideration_id '
            'FROM {table_name} as T2 '
            'WHERE T1.id = T2.application_id AND T1.consideration_id IS NULL'
        )

    @classmethod
    def _insert(cls, values_str):
        cls._execute_raw_sql(
            'INSERT INTO {table_name} (application_id, consideration_id) '
            'VALUES ' + values_str
        )

    @classmethod
    def _values_to_str(cls, values):
        return '(%s)' % ', '.join(map(str, values))

    @classmethod
    def _insert_one(cls, values):
        cls._insert(cls._values_to_str(values))

    @classmethod
    def _bulk_insert(cls, values_list, batch_size=1000):
        start = 0
        while start < len(values_list):
            end = start + batch_size
            values_str_list = map(cls._values_to_str, values_list[start:end])
            cls._insert(', '.join(values_str_list))
            start = end

    @classmethod
    def update_applications(cls, values_list):
        cls._create()
        cls._bulk_insert(values_list)
        cls._update_applications()
        cls._drop()
