from django.contrib import admin

from . import models


class AttachmentModelAdmin(admin.ModelAdmin):

    raw_id_fields = (
        'uploader',
    )

    search_fields = (
        'id',
        'name',
    )

    list_display = (
        'id',
        'name',
        'size',
        'attached_file',
        'content_type',
    )

    list_filter = (
        'content_type',
    )


admin.site.register(models.Attachment, AttachmentModelAdmin)
