from intranet.femida.src.candidates.models import CandidateAttachment, CandidateSubmission
from intranet.femida.src.communications.models import MessageAttachment
from intranet.femida.src.offers.models import OfferAttachment
from intranet.femida.src.permissions.context import context


def is_attachment_available(attachment):
    """
    TODO: На CandidateSubmission и OfferProfileAttachment сейчас не висит никаких доступов
    TODO: Список models можно формировать автоматически, но тогда потеряем последовательность
    проверок, что может быть важным.
    """
    if context.user.is_superuser:
        return True
    models = [
        CandidateAttachment,
        MessageAttachment,
        CandidateSubmission,
        OfferAttachment,
    ]

    for model in models:
        if model.objects.filter(attachment=attachment).exists():
            return True

    return False
