# flake8: noqa
"""
Здесь собраны первые варианты sql-функций для выгрузки данных
из Фемиды в Beamery.
В дальнейшем планируется, что мы просто будем в БД пересоздавать функции,
если там потребуются какие-то изменения.

В таком виде мы должны просуществовать до перехода на YMQ при выгрузке из Фемиды в Beamery.
"""
from django.db import migrations

# Note: Все SQL-запросы взяты от интегратора как есть.
# Они с плохим стилем кода, но переформатировать сейчас мы не готовы.


CANDIDATES = """
    (SELECT array_to_json(array_agg(row_to_json(t))), max(femida_id) as max_id FROM
    (SELECT
    touched_at,
    modified,
    first_name,
    last_name,
    middle_name,
    birthday,
    country,
    city,
    login,
    id AS "femida_id",
    beamery_id,
    gender,
    status,
    original_id,
    is_hidden OR EXISTS (
        SELECT appl.id FROM interviews_application appl
        JOIN vacancies_vacancy vac ON appl.vacancy_id = vac.id
        WHERE
            appl.candidate_id = cand.id
            AND vac.is_hidden = true
            AND vac.status != 'closed'
    ) AS is_hidden,
    (SELECT au.is_dismissed FROM auth_user au WHERE cand.login NOTNULL AND cand.login = au.username LIMIT 1) AS is_dismissed,
    (SELECT cc.resolution FROM candidates_consideration cc WHERE cc.candidate_id = cand.id AND cc.id = (SELECT MAX(cc2.id) FROM candidates_consideration cc2  WHERE cc2.candidate_id = cand.id)) AS consideration_resolution,
    (SELECT cc.source FROM candidates_consideration cc WHERE cc.candidate_id = cand.id AND cc.id = (SELECT MAX(cc2.id) FROM candidates_consideration cc2  WHERE cc2.candidate_id = cand.id)) AS consideration_source,
    (select au.first_name || ' ' || au.last_name FROM auth_user au JOIN candidates_candidate_responsibles ccr ON au.id = ccr.user_id WHERE ccr.candidate_id = cand.id AND ccr.role = 'main_recruiter') AS yandex_owner,
    (SELECT au.username FROM candidates_candidate_responsibles ccr JOIN auth_user au ON au.id = ccr.user_id WHERE ccr.candidate_id = cand.id AND ccr.role = 'main_recruiter') AS yandex_owner_id,
    (SELECT array_to_json(array_agg(row_to_json(f))) FROM (SELECT is_active, type, is_main, normalized_account_id FROM candidates_candidatecontact cont WHERE cand.id = cont.candidate_id) f) AS contacts,
    (SELECT array_to_json(array_agg(row_to_json(h))) FROM (SELECT created, employer, position, start_date, end_date FROM candidates_candidatejob job WHERE cand.id = job.candidate_id ORDER BY job.start_date ASC) h ) AS experience,
    (SELECT array_to_json(array_agg(row_to_json(k))) FROM (SELECT institution, faculty, degree, start_date, end_date FROM candidates_candidateeducation edu WHERE cand.id = edu.candidate_id) k ) AS education,
    (SELECT skills FROM (SELECT candskl.candidate_id AS id, array_agg(skl.name) AS skills FROM candidates_candidateskill candskl JOIN skills_skill skl ON skl.id = candskl.skill_id WHERE skl.name NOTNULL GROUP BY candskl.candidate_id) m WHERE cand.id = m.id) AS skills,
    (SELECT professions FROM (SELECT candprof.candidate_id AS id, array_agg(pp.name_en) AS professions FROM candidates_candidateprofession candprof JOIN professions_profession pp ON pp.id = candprof.profession_id WHERE pp.name_en NOTNULL GROUP BY candprof.candidate_id) n WHERE cand.id = n.id ) as professions,
    (SELECT professional_spheres FROM (SELECT candprof.candidate_id AS id, array_agg(pps.name_en) AS professional_spheres FROM candidates_candidateprofession candprof JOIN professions_professionalsphere pps ON pps.id = candprof.professional_sphere_id WHERE pps.name_en NOTNULL GROUP BY candprof.candidate_id) o WHERE cand.id = o.id) AS professional_spheres,
    (SELECT tags FROM (SELECT candtgs.candidate_id AS id, array_agg(tgs.name) AS tags FROM candidates_candidatetag candtgs JOIN core_tag tgs ON tgs.id = candtgs.tag_id WHERE tgs.name NOTNULL and candtgs.is_active GROUP BY candtgs.candidate_id) r WHERE cand.id = r.id) AS tags,
    (SELECT array_to_json(array_agg(row_to_json(i))) FROM (SELECT interviews_interview.grade AS grade, interviews_interview.type AS type, candidates_consideration.created AS consideration_created, candidates_consideration.id AS consideration_id FROM interviews_interview JOIN candidates_consideration ON interviews_interview.consideration_id = candidates_consideration.id WHERE interviews_interview.state = 'finished' AND cand.id = candidates_consideration.candidate_id) i) AS interviews,
    (SELECT row_to_json(tt) FROM (SELECT
        (SELECT CASE WHEN EXISTS (SELECT * FROM candidates_consideration cc3 WHERE cc3.candidate_id = cand.id AND cc3.state = 'in_progress' ORDER BY cc3.modified DESC LIMIT 1) THEN true ELSE false END) as state,
        (SELECT cc4.extended_status FROM candidates_consideration cc4 WHERE cc4.candidate_id = cand.id order by cc4.modified DESC LIMIT 1) as extended_status,
        (SELECT au2.username FROM auth_user au2 WHERE au2.username = cand.login LIMIT 1) as login,
        (SELECT au3.is_dismissed FROM auth_user au3 WHERE au3.username = cand.login LIMIT 1) as is_dismissed,
        (SELECT au4.is_intern FROM auth_user au4 WHERE au4.username = cand.login LIMIT 1) as is_intern
        FROM candidates_candidate cc9 WHERE cc9.id = cand.id
    ) tt) AS global_status
    FROM candidates_candidate AS cand
    WHERE
        id > $2
        AND is_duplicate = false
        {delta_suffix}
    ORDER BY id ASC LIMIT $1) t);
"""
CANDIDATES_DELTA_SUFFIX = 'AND cand.touched_at >= $3'

VACANCIES = """
    (SELECT array_to_json(array_agg(row_to_json(t))), max(femida_id) as max_id FROM
    (SELECT
    vac.id AS "femida_id",
    vac.name,
    (SELECT au.first_name FROM vacancies_vacancymembership vvm JOIN auth_user au ON au.id = vvm.member_id  WHERE vvm.vacancy_id = vac.id AND vvm.role = 'head') AS first_name,
    (SELECT au.last_name FROM vacancies_vacancymembership vvm JOIN auth_user au ON au.id = vvm.member_id  WHERE vvm.vacancy_id = vac.id AND vvm.role = 'head') AS last_name,
    (SELECT au.id FROM vacancies_vacancymembership vvm JOIN auth_user au ON au.id = vvm.member_id  WHERE vvm.vacancy_id = vac.id AND vvm.role = 'main_recruiter') AS auth_user_id,
    vac.status,
    vac.deadline,
    vac.touched_at,
    vac.modified
    FROM vacancies_vacancy AS vac
    WHERE
        vac.id > $2
        AND vac.status IN ('suspended', 'closed', 'offer_accepted', 'offer_processing', 'in_progress')
        AND vac.is_hidden = false
    {delta_suffix}
    ORDER BY vac.id ASC LIMIT $1) t);
"""
VACANCIES_DELTA_SUFFIX = 'AND vac.touched_at >= $3'

NOTES = """
    (SELECT array_to_json(array_agg(row_to_json(t))), max(femida_id) as max_id FROM
    (SELECT
    cm.id AS "femida_id",
    cm.text,
    au.first_name,
    au.last_name,
    cm.candidate_id,
    cm.is_changed,
    cm.created,
    cm.modified
    FROM communications_message cm JOIN auth_user au ON cm.author_id = au.id
    WHERE
        cm.id > $2
        AND cm.type = 'official'
        AND cm.status = 'sent'
    {delta_suffix}
    ORDER BY cm.id ASC LIMIT $1) t);
"""
NOTES_DELTA_SUFFIX = 'AND cm.modified >= $3'

APPLICATIONS = """
    (SELECT array_to_json(array_agg(row_to_json(t))), max(id) as max_id FROM
    (SELECT
        app.id,
        app.candidate_id,
        app.status,
        app.resolution,
        app.vacancy_id,
        app.modified
    FROM interviews_application AS app
    WHERE app.id > $2
    {delta_suffix}
    ORDER BY app.id ASC LIMIT $1) t);
"""
APPLICATIONS_DELTA_SUFFIX = 'AND app.modified >= $3'

CREATE_FUNCTION_TEMPLATE = """
    CREATE FUNCTION get_{model}_for_beamery(_limit int, _id__gt int)
    RETURNS TABLE (data json, max_id int) AS $$
    {sql}
    $$ LANGUAGE sql;
"""
CREATE_DELTA_FUNCTION_TEMPLATE = """
    CREATE FUNCTION get_{model}_for_beamery(_limit int, _id__gt int, _modified__gte timestamptz)
    RETURNS TABLE (data json, max_id int) AS $$
    {sql}
    $$ LANGUAGE sql;
"""
DROP_FUNCTION_TEMPLATE = 'DROP FUNCTION IF EXISTS get_{model}_for_beamery;'

# model: function body
function_bodies = {
    'candidates': CANDIDATES.format(delta_suffix=''),
    'vacancies': VACANCIES.format(delta_suffix=''),
    'notes': NOTES.format(delta_suffix=''),
    'applications': APPLICATIONS.format(delta_suffix=''),
}
delta_function_bodies = {
    'delta_candidates': CANDIDATES.format(delta_suffix=CANDIDATES_DELTA_SUFFIX),
    'delta_vacancies': VACANCIES.format(delta_suffix=VACANCIES_DELTA_SUFFIX),
    'delta_notes': NOTES.format(delta_suffix=NOTES_DELTA_SUFFIX),
    'delta_applications': APPLICATIONS.format(delta_suffix=APPLICATIONS_DELTA_SUFFIX),
}

forward_sql_operations = [
    CREATE_FUNCTION_TEMPLATE.format(model=model, sql=sql)
    for model, sql in function_bodies.items()
]
forward_sql_operations += [
    CREATE_DELTA_FUNCTION_TEMPLATE.format(model=model, sql=sql)
    for model, sql in delta_function_bodies.items()
]
backward_sql_operations = [
    DROP_FUNCTION_TEMPLATE.format(model=model)
    for model in function_bodies | delta_function_bodies
]


class Migration(migrations.Migration):

    dependencies = [
        ('candidates', '0034_considerationissue'),
        ('communications', '0007_submission_handle'),
        ('interviews', '0011_interviewround_comment'),
        ('vacancies', '0016_vacancy_geography'),
    ]

    operations = [
        migrations.RunSQL(sql, reverse_sql)
        for sql, reverse_sql in zip(forward_sql_operations, backward_sql_operations)
    ]
