import boto3
import io

from django.conf import settings


def _get_resource():
    session = boto3.Session(
        region_name=settings.BEAMERY_S3_REGION,
        aws_access_key_id=settings.BEAMERY_S3_ACCESS_KEY_ID,
        aws_secret_access_key=settings.BEAMERY_S3_SECRET_ACCESS_KEY,
    )
    return session.resource('s3', endpoint_url=f'https://{settings.BEAMERY_S3_ENDPOINT}/')


def upload(data: bytes, filename: str):
    resource = _get_resource()
    bucket = resource.Bucket(settings.BEAMERY_S3_F2B_BUCKET_NAME)
    file = io.BytesIO(data)
    bucket.upload_fileobj(file, filename)
