import waffle

from intranet.femida.src.beamery.controllers import BeameryUploader
from intranet.femida.src.celery_app import app
from intranet.femida.src.utils.lock import locked_task


@app.autoretry_task(max_retries=3)
@locked_task
def upload_candidates_to_beamery_task(delta=True):
    if delta and not waffle.switch_is_active('enable_upload_candidates_to_beamery'):
        return
    uploader = BeameryUploader('candidates')
    uploader.upload(delta)


@app.autoretry_task(max_retries=3)
@locked_task
def upload_vacancies_to_beamery_task(delta=True):
    if delta and not waffle.switch_is_active('enable_upload_vacancies_to_beamery'):
        return
    uploader = BeameryUploader('vacancies')
    uploader.upload(delta)


@app.autoretry_task(max_retries=3)
@locked_task
def upload_notes_to_beamery_task(delta=True):
    if delta and not waffle.switch_is_active('enable_upload_notes_to_beamery'):
        return
    uploader = BeameryUploader('notes')
    uploader.upload(delta)


@app.autoretry_task(max_retries=3)
@locked_task
def upload_applications_to_beamery_task(delta=True):
    if delta and not waffle.switch_is_active('enable_upload_applications_to_beamery'):
        return
    uploader = BeameryUploader('applications')
    uploader.upload(delta)


@app.task
def log_invalid_data_task(data, errors):
    """
    Временный таск, чтобы следить за интеграцией с Бимери.
    Записывает ошибки в celery-results. Будет замьючен в проде
    """
    raise Exception


@app.task
def log_fatally_invalid_data_task(data, errors):
    """
    Временный таск, чтобы следить за интеграцией с Бимери.
    Записывает фатальные ошибки в celery-results
    """
    raise Exception
