from django.utils.functional import cached_property

from intranet.femida.src.core.models import City
from intranet.femida.src.professions.models import Profession
from intranet.femida.src.skills.models import Skill


class CandidateDictionariesCache:
    """
    Класс для кэширования разных словарей,
    необходимых для балкового создания кандидатов.
    """

    @cached_property
    def cities(self):
        return City.active.all()

    @cached_property
    def professions(self):
        return Profession.active.all()

    @cached_property
    def skills(self):
        return Skill.objects.all()

    @cached_property
    def cities_by_name_map(self):
        return {i.name_ru: i for i in self.cities}

    @cached_property
    def professions_by_name_map(self):
        return {i.name: i for i in self.professions}

    @cached_property
    def skills_by_name_map(self):
        # Скиллы - регистронезависимы
        return {i.name.lower(): i for i in self.skills}
