from django.utils import timezone

from intranet.femida.src.candidates import choices
from intranet.femida.src.candidates.considerations.controllers import (
    update_consideration_extended_status,
)
from intranet.femida.src.candidates.tasks import send_onedayoffer_challenge_results_task
from intranet.femida.src.comments.controllers import update_or_create_comment
from intranet.femida.src.core.workflow import Action, Workflow
from intranet.femida.src.notifications.challenges import ChallengeEstimatedNotification


class EstimateAction(Action):

    valid_statuses = (
        choices.CHALLENGE_STATUSES.pending_review,
    )

    def perform(self, **params):
        self.instance.status = choices.CHALLENGE_STATUSES.finished
        self.instance.resolution = params['resolution']
        self.instance.comment = params['comment']
        self.instance.reviewed_by = self.user
        self.instance.finished = timezone.now()
        self.instance.finished_by = self.user
        self.instance.save()
        update_consideration_extended_status(self.instance.consideration)
        send_onedayoffer_challenge_results_task.delay(self.instance.id)
        notification = ChallengeEstimatedNotification(self.instance, self.user)
        notification.send()
        return self.instance


class CommentAddAction(Action):

    valid_statuses = (
        choices.CHALLENGE_STATUSES.finished,
    )

    def perform(self, **params):
        params['related_object'] = self.instance
        return update_or_create_comment(params, self.user)


class CancelAction(Action):

    valid_statuses = (
        choices.CHALLENGE_STATUSES.assigned,
    )

    def has_permission(self):
        return self.instance.type == choices.CHALLENGE_TYPES.contest

    def perform(self, **params):
        self.instance.cancel_reason = params['cancel_reason']
        self.instance.status = choices.CHALLENGE_STATUSES.cancelled
        self.instance.save()
        update_consideration_extended_status(self.instance.consideration)
        return self.instance


class ChallengeWorkflow(Workflow):

    ACTION_MAP = {
        # TODO: estimate лучше переименовать в finish, чтобы не было путаницы со статусами
        'estimate': EstimateAction,
        'comment_add': CommentAddAction,
        'cancel': CancelAction,
    }
