from django.utils.translation import ugettext_noop as _
from model_utils import Choices

from intranet.femida.src.core.choices import get_partial_choices
from intranet.femida.src.offers.choices import OFFER_STATUSES


CANDIDATE_STATUSES = Choices(
    ('in_progress', _('candidate.status.in_progress')),
    ('closed', _('candidate.status.closed')),
)

CANDIDATE_STATUSES_TRANSLATIONS = {
    CANDIDATE_STATUSES.in_progress: 'В работе',
    CANDIDATE_STATUSES.closed: 'Закрыт',
}

CANDIDATE_SORTING_TYPES = Choices(
    ('relevance', _('candidate.sorting.relevance')),
    ('modified_asc', _('candidate.sorting.modified_asc')),
    ('modified_desc', _('candidate.sorting.modified_desc')),
)

CANDIDATE_RESPONSIBLE_ROLES = Choices(
    ('main_recruiter', _('candidate_responsible.role.main_recruiter')),
    ('recruiter', _('candidate_responsible.role.recruiter')),
)

VERIFICATION_TYPES = Choices(
    ('default', _('verification.type.default')),
    ('international_by_grade', _('verification.type.international_by_grade')),
)

VERIFICATION_STATUSES = Choices(
    ('new', _('verification.status.new')),
    ('on_check', _('verification.status.on_check')),
    ('on_ess_check', _('verification.status.on_ess_check')),  # разбирается вручную в ESS тикете
    ('closed', _('verification.status.closed')),
)

VERIFICATION_RESOLUTIONS = Choices(
    ('hire', _('verification.resolution.hire')),
    ('nohire', _('verification.resolution.nohire')),
    ('blacklist', _('verification.resolution.blacklist')),
)

CONSIDERATION_STATUSES = Choices(
    ('in_progress', 'В прогрессе'),
    ('archived', 'В архиве'),
)

CONSIDERATION_RESOLUTIONS = Choices(
    ('rejected_by_resume', _('consideration.resolution.rejected_by_resume')),
    ('rejected_after_test_task', _('consideration.resolution.rejected_after_test_task')),
    ('rejected_after_screening', _('consideration.resolution.rejected_after_screening')),
    ('rejected_after_preliminary_interview', _(
        'consideration.resolution.rejected_after_preliminary_interview'
    )),
    ('rejected_after_onsite_interview', _(
        'consideration.resolution.rejected_after_onsite_interview'
    )),
    ('rejected_after_final_interview', _(
        'consideration.resolution.rejected_after_final_interview'
    )),
    ('refused_did_not_respond', _('consideration.resolution.refused_did_not_respond')),
    ('refused_after_vacancy_proposal', _(
        'consideration.resolution.refused_after_vacancy_proposal'
    )),
    ('refused_after_test_task', _('consideration.resolution.refused_after_test_task')),
    ('refused_after_screening', _('consideration.resolution.refused_after_screening')),
    ('refused_after_preliminary_interview', _(
        'consideration.resolution.refused_after_preliminary_interview'
    )),
    ('refused_after_onsite_interview', _(
        'consideration.resolution.refused_after_onsite_interview'
    )),
    ('refused_after_final_interview', _('consideration.resolution.refused_after_final_interview')),
    ('duplicate', _('consideration.resolution.duplicate')),
    ('no_offer', _('consideration.resolution.no_offer')),
    ('offer_rejected', _('consideration.resolution.offer_rejected')),
    ('offer_accepted', _('consideration.resolution.offer_accepted')),
    ('vacancy_closed', _('consideration.resolution.vacancy_closed')),
    ('rotated', _('consideration.resolution.rotated')),
)

CONSIDERATION_RESOLUTIONS_TRANSLATIONS = {
    CONSIDERATION_RESOLUTIONS.rejected_by_resume: 'Отказали мы по резюме или отклику',
    CONSIDERATION_RESOLUTIONS.rejected_after_test_task: 'Отказали мы после тестового задания',
    CONSIDERATION_RESOLUTIONS.rejected_after_screening: 'Отказали мы после скрининга рекрутера',
    CONSIDERATION_RESOLUTIONS.rejected_after_preliminary_interview: (
        'Отказали мы после предварительного интервью'
    ),
    CONSIDERATION_RESOLUTIONS.rejected_after_onsite_interview: (
        'Отказали мы после очного собеседования'
    ),
    CONSIDERATION_RESOLUTIONS.rejected_after_final_interview: (
        'Отказали мы после финального собеседования'
    ),
    CONSIDERATION_RESOLUTIONS.refused_did_not_respond: 'Отказался сам не ответил',
    CONSIDERATION_RESOLUTIONS.refused_after_vacancy_proposal: (
        'Отказался сам после предложения вакансии'
    ),
    CONSIDERATION_RESOLUTIONS.refused_after_test_task: 'Отказался сам после тестового задания',
    CONSIDERATION_RESOLUTIONS.refused_after_screening: 'Отказался сам после скрининга с рекрутером',
    CONSIDERATION_RESOLUTIONS.refused_after_preliminary_interview: (
        'Отказался сам после предварительного интервью'
    ),
    CONSIDERATION_RESOLUTIONS.refused_after_onsite_interview: (
        'Отказался сам после очного собеседования'
    ),
    CONSIDERATION_RESOLUTIONS.refused_after_final_interview: (
        'Отказался сам после финального собеседования'
    ),
    CONSIDERATION_RESOLUTIONS.offer_rejected: 'Отказался от оффера',
    CONSIDERATION_RESOLUTIONS.offer_accepted: 'Оффер принят/Нанят',
    CONSIDERATION_RESOLUTIONS.vacancy_closed: 'Вакансия закрыта, не успели рассмотреть',
    CONSIDERATION_RESOLUTIONS.duplicate: 'Дубликат',
    CONSIDERATION_RESOLUTIONS.no_offer: 'Решили не делать оффер',
    CONSIDERATION_RESOLUTIONS.rotated: 'Ротирован',
}

CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER = Choices(
    ('in_progress', _('consideration.status.in_progress')),
    ('challenge_assigned', _('consideration.status.challenge_assigned')),
    ('challenge_pending_review', _('consideration.status.challenge_pending_review')),
    ('challenge_finished', _('consideration.status.challenge_finished')),
    ('hr_screening_assigned', _('consideration.status.hr_screening_assigned')),
    ('hr_screening_finished', _('consideration.status.hr_screening_finished')),
    ('screening_assigned', _('consideration.status.screening_assigned')),
    ('screening_finished', _('consideration.status.screening_finished')),
    ('interview_assigned', _('consideration.status.interview_assigned')),
    ('interview_finished', _('consideration.status.interview_finished')),
    ('final_assigned', _('consideration.status.final_assigned')),
    ('final_finished', _('consideration.status.final_finished')),
)

CONSIDERATION_ARCHIVED_EXTENDED_STATUSES_WITHOUT_OFFER = Choices(
    ('archived', _('consideration.status.archived')),
)

CONSIDERATION_EXTENDED_STATUSES_WITHOUT_OFFER = (
    CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER
    + CONSIDERATION_ARCHIVED_EXTENDED_STATUSES_WITHOUT_OFFER
)

CONSIDERATION_EXTENDED_STATUSES_WITH_OFFER = Choices(
    ('offer_preparing', _('consideration.status.offer_preparing')),
    ('offer_on_approval', _('consideration.status.offer_on_approval')),
    ('offer_sent', _('consideration.status.offer_sent')),
    ('offer_accepted', _('consideration.status.offer_accepted')),
)

CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES = (
    CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER
    + CONSIDERATION_EXTENDED_STATUSES_WITH_OFFER
)

CONSIDERATION_ARCHIVED_EXTENDED_STATUSES = CONSIDERATION_ARCHIVED_EXTENDED_STATUSES_WITHOUT_OFFER

CONSIDERATION_EXTENDED_STATUSES = (
    CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES_WITHOUT_OFFER
    + CONSIDERATION_EXTENDED_STATUSES_WITH_OFFER
    + CONSIDERATION_ARCHIVED_EXTENDED_STATUSES_WITHOUT_OFFER
)


CONSIDERATION_STATUSES_WITHOUT_OFFER_TRANSLATIONS = {
    CONSIDERATION_EXTENDED_STATUSES.in_progress: 'В работе',
    CONSIDERATION_EXTENDED_STATUSES.challenge_assigned: 'Назначено испытание',
    CONSIDERATION_EXTENDED_STATUSES.challenge_pending_review: 'Испытание ожидает ревью',
    CONSIDERATION_EXTENDED_STATUSES.challenge_finished: 'Испытание завершено',
    CONSIDERATION_EXTENDED_STATUSES.hr_screening_assigned: 'Назначен HR скрининг',
    CONSIDERATION_EXTENDED_STATUSES.hr_screening_finished: 'Завершён HR скрининг',
    CONSIDERATION_EXTENDED_STATUSES.screening_assigned: 'Назначена предварительная секция',
    CONSIDERATION_EXTENDED_STATUSES.screening_finished: 'Завершена предварительная секция',
    CONSIDERATION_EXTENDED_STATUSES.interview_assigned: 'Назначены очные секции',
    CONSIDERATION_EXTENDED_STATUSES.interview_finished: 'Очные секции завершены',
    CONSIDERATION_EXTENDED_STATUSES.final_assigned: 'Назначены финальные секции',
    CONSIDERATION_EXTENDED_STATUSES.final_finished: 'Финальные секции завершены',
    CONSIDERATION_EXTENDED_STATUSES.archived: 'Все секции архивные',
}

CONSIDERATION_STATUSES_WITH_OFFER_TRANSLATIONS = {
    CONSIDERATION_EXTENDED_STATUSES.offer_preparing: 'Оффер готовится',
    CONSIDERATION_EXTENDED_STATUSES.offer_on_approval: 'Оффер на согласовании',
    CONSIDERATION_EXTENDED_STATUSES.offer_sent: 'Оффер отправлен',
    CONSIDERATION_EXTENDED_STATUSES.offer_accepted: 'Оффер принят',
}

CONSIDERATION_STATUSES_TRANSLATIONS = dict(
    **CONSIDERATION_STATUSES_WITHOUT_OFFER_TRANSLATIONS,
    **CONSIDERATION_STATUSES_WITH_OFFER_TRANSLATIONS,
)

CONSIDERATION_ISSUE_LEVELS = Choices(
    ('danger', _('consideration_issue.level.danger')),
    ('warning', _('consideration_issue.level.warning')),
)

# Маппинг каким статусам офферов соответствуют EXTENDED_STATUSES рассмотрений
OFFER_STATUSES_BY_CONSIDERATION_STATUS = {
    CONSIDERATION_EXTENDED_STATUSES.offer_preparing: {
        OFFER_STATUSES.draft,
        OFFER_STATUSES.ready_for_approval,
    },
    CONSIDERATION_EXTENDED_STATUSES.offer_on_approval: {
        OFFER_STATUSES.on_rotation_approval,
        OFFER_STATUSES.on_approval,
    },
    CONSIDERATION_EXTENDED_STATUSES.offer_sent: {OFFER_STATUSES.sent},
    CONSIDERATION_EXTENDED_STATUSES.offer_accepted: {OFFER_STATUSES.accepted},
}

CONSIDERATION_RECRUITER_STAGES = Choices(
    ('assessment_assigned', _('consideration.recruiter_stage.assessment_assigned')),
    ('assessment_finished', _('consideration.recruiter_stage.assessment_finished')),
    ('no_assessment', _('consideration.recruiter_stage.no_assessment')),
)

CONSIDERATION_RECRUITER_STAGE_EXTENDED_STATUSES = {
    CONSIDERATION_RECRUITER_STAGES.assessment_assigned: (
        CONSIDERATION_EXTENDED_STATUSES.challenge_assigned,
        CONSIDERATION_EXTENDED_STATUSES.challenge_pending_review,
        CONSIDERATION_EXTENDED_STATUSES.hr_screening_assigned,
        CONSIDERATION_EXTENDED_STATUSES.screening_assigned,
        CONSIDERATION_EXTENDED_STATUSES.interview_assigned,
        CONSIDERATION_EXTENDED_STATUSES.final_assigned,
    ),
    CONSIDERATION_RECRUITER_STAGES.assessment_finished: (
        CONSIDERATION_EXTENDED_STATUSES.challenge_finished,
        CONSIDERATION_EXTENDED_STATUSES.hr_screening_finished,
        CONSIDERATION_EXTENDED_STATUSES.screening_finished,
        CONSIDERATION_EXTENDED_STATUSES.interview_finished,
        CONSIDERATION_EXTENDED_STATUSES.final_finished,
        CONSIDERATION_EXTENDED_STATUSES.offer_preparing,
        CONSIDERATION_EXTENDED_STATUSES.offer_on_approval,
        CONSIDERATION_EXTENDED_STATUSES.offer_sent,
        CONSIDERATION_EXTENDED_STATUSES.offer_accepted,
    ),
    CONSIDERATION_RECRUITER_STAGES.no_assessment: (
        CONSIDERATION_EXTENDED_STATUSES.in_progress,
    ),
}

CONSIDERATION_DASHBOARD_STAGES = (
    CONSIDERATION_IN_PROGRESS_EXTENDED_STATUSES
    + CONSIDERATION_RESOLUTIONS
)
CONSIDERATION_DASHBOARD_STAGES = Choices(*[x for x, _ in CONSIDERATION_DASHBOARD_STAGES])

SLA_STATUSES = Choices(
    ('warning', _('consideration.sla.warning')),
    ('danger', _('consideration.sla.danger')),
)

CURRENCIES = Choices(
    ('rub', _('currency.rub')),
    ('usd', _('currency.usd')),
)

CONTACT_SOURCES = Choices(
    ('separator', _('candidate.contact_source.separator')),
    ('forms', _('candidate.contact_source.forms')),
    ('staff', _('candidate.contact_source.staff')),
    ('other', _('candidate.contact_source.other')),
)

RKN_CONTACT_TYPES = Choices(
    ('skype', _('candidate.contact_type.skype')),
    ('phone', _('candidate.contact_type.phone')),
    ('email', _('candidate.contact_type.email')),
)

CONTACT_TYPES = Choices(
    ('skype', _('candidate.contact_type.skype')),
    ('phone', _('candidate.contact_type.phone')),
    ('email', _('candidate.contact_type.email')),
    ('hh', _('candidate.contact_type.hh')),
    ('ah', _('candidate.contact_type.ah')),
    ('linkedin', _('candidate.contact_type.linkedin')),
    ('telegram', _('candidate.contact_type.telegram')),
    ('facebook', _('candidate.contact_type.facebook')),
    ('vk', _('candidate.contact_type.vk')),
    ('github', _('candidate.contact_type.github')),
    ('behance', _('candidate.contact_type.behance')),
    ('dribbble', _('candidate.contact_type.dribbble')),
    ('beamery', _('candidate.contact_type.beamery')),
    ('other', _('candidate.contact_type.other')),
)

ATTACHMENT_TYPES = Choices(
    ('resume', _('candidate.attachment_type.resume')),
)

CANDIDATE_DEGREES = Choices(
    ('unknown', _('candidate.degree.unknown')),
    ('studying', _('candidate.degree.studying')),
    ('not_finished', _('candidate.degree.not_finished')),
    ('bachelor', _('candidate.degree.bachelor')),
    ('masters', _('candidate.degree.masters')),
    ('specialist', _('candidate.degree.specialist')),
)

# Статусы откликов, которые доступны рядовым рекрутерам
RECRUITER_SUBMISSION_STATUSES = Choices(
    ('new', _('submission.status.new')),  # Отклик можно обрабатывать
    ('closed', _('submission.status.closed')),
)

SUBMISSION_STATUSES = Choices(
    ('draft', _('submission.status.draft')),  # Отклик ожидает обработки рекомендации/ротации
) + RECRUITER_SUBMISSION_STATUSES

EXTERNAL_SUBMISSION_SOURCES = Choices(
    ('form', _('submission.source.form')),
    ('publication', _('submission.source.publication')),
)

SUBMISSION_SOURCES = Choices(
    ('reference', _('submission.source.reference')),
    ('rotation', _('submission.source.rotation')),
) + EXTERNAL_SUBMISSION_SOURCES

# Источники откликов, которые отдаем на фронт
PUBLIC_SUBMISSION_SOURCES = get_partial_choices(
    SUBMISSION_SOURCES,
    SUBMISSION_SOURCES.form,
    SUBMISSION_SOURCES.rotation,
    SUBMISSION_SOURCES.reference,
)

REFERENCE_STATUSES = Choices(
    ('new', _('reference.status.new')),
    ('approved', _('reference.status.approved')),
    ('approved_without_benefits', _('reference.status.approved_without_benefits')),
    ('rejected', _('reference.status.rejected')),
)

REFERENCE_EVENTS = CONSIDERATION_EXTENDED_STATUSES_WITHOUT_OFFER + Choices(
    ('consideration_created', _('reference.event.consideration_created')),
    ('consideration_archived', _('reference.event.consideration_archived')),
    ('offer_accepted', _('reference.event.offer_accepted')),
    ('offer_deleted', _('reference.event.offer_deleted')),
    ('offer_rejected', _('reference.event.offer_rejected')),
    ('offer_closed', _('reference.event.offer_closed')),
)

REFERENCE_EVENTS_TRANSLATIONS = dict({
    REFERENCE_EVENTS.consideration_created: 'Начато рассмотрение кандидата',
    REFERENCE_EVENTS.consideration_archived: 'Рассмотрение кандидата завершено',
    REFERENCE_EVENTS.offer_accepted: 'Кандидат принял оффер',
    REFERENCE_EVENTS.offer_deleted: 'Рекрутер отменил оффер',
    REFERENCE_EVENTS.offer_rejected: 'Кандидат отклонил оффер',
    REFERENCE_EVENTS.offer_closed: (
        'Кандидат по рекомендации сегодня стал сотрудником и выведен на Стафф! '
        'Начинаем процесс оформления вознаграждения.'
    ),
}, **CONSIDERATION_STATUSES_WITHOUT_OFFER_TRANSLATIONS)

ROTATION_EVENTS = Choices(
    ('rotation_on_approval', _('rotation.event.rotation_on_approval')),
    ('rotation_approved', _('rotation.event.rotation_approved')),
    ('rotation_rejected', _('rotation.event.rotation_rejected')),
)

ROTATION_EVENTS_TRANSLATIONS = {
    ROTATION_EVENTS.rotation_on_approval: 'Начато согласование ротации',
    ROTATION_EVENTS.rotation_approved: 'Ротация согласована',
    ROTATION_EVENTS.rotation_rejected: 'Ротация отменена',
}

DUPLICATION_CASE_STATUSES = Choices(
    ('new', _('duplication_case.status.new')),
    ('closed', _('duplication_case.status.closed')),
)

DUPLICATION_CASE_RESOLUTIONS = Choices(
    ('duplicate', _('duplication_case.resolution.duplicate')),
    ('not_duplicate', _('duplication_case.resolution.not_duplicate')),
    ('unclear', _('duplication_case.resolution.unclear')),
)

CHALLENGE_TYPES = Choices(
    ('quiz', _('challenge.type.quiz')),
    ('contest', _('challenge.type.contest')),
)

CHALLENGE_STATUSES = Choices(
    ('assigned', _('challenge.status.assinged')),  # Назначена
    ('pending_review', _('challenge.status.pending_review')),  # Выполнена кандидатом, ожидает ревью
    ('finished', _('challenge.status.finished')),  # Оценена ревьюером
    ('cancelled', _('challenge.status.cancelled')),  # Испытание отменено
)

CHALLENGE_RESOLUTIONS = Choices(
    ('hire', _('challenge.resolution.hire')),
    ('nohire', _('challenge.resolution.nohire')),
)

CHALLENGE_RESOLUTIONS_TRANSLATIONS = {
    CHALLENGE_RESOLUTIONS.hire: 'рассматриваем',
    CHALLENGE_RESOLUTIONS.nohire: 'отказываем',
}

LINKED_ENTITY_TYPES = Choices(
    ('hh', _('linked_entity.type.hh')),
    ('amazing_hiring', _('linked_entity.type.amazing_hiring')),
)

ROTATION_REASONS = Choices(
    ('product_change', _('rotation.reason.product_change')),
    ('career_growth', _('rotation.reason.career_growth')),
    ('profession_change', _('rotation.reason.profession_change')),
    ('team_change', _('rotation.reason.team_change')),
    ('other', _('rotation.reason.other')),
)

ROTATION_REASONS_TRANSLATIONS = {
    ROTATION_REASONS.product_change: 'Желание сменить проект',
    ROTATION_REASONS.career_growth: 'Карьерный рост',
    ROTATION_REASONS.profession_change: 'Желание сменить род деятельности',
    ROTATION_REASONS.team_change: 'Желание сменить команду',
    ROTATION_REASONS.other: 'Другое',
}

ROTATION_STATUSES = Choices(
    ('new', _('rotation.status.new')),
    ('approved', _('rotation.status.approved')),
    ('rejected', _('rotation.status.rejected')),
)

CANDIDATE_COST_GROUPS = Choices(
    ('expectation', _('canidate.cost.group.expectation')),
    ('current', _('canidate.cost.group.current')),
)

CANDIDATE_COST_TYPES_MONEY = Choices(
    ('total', _('canidate.cost.type.total')),
    ('salary', _('canidate.cost.type.salary')),
    ('salary_bonus', _('canidate.cost.type.salary_bonus')),
)

CANDIDATE_COST_TYPES_SHARE = Choices(
    ('rsu', _('canidate.cost.type.rsu')),
)

CANDIDATE_COST_TYPES_COMMENT = Choices(
    ('comment', _('canidate.cost.type.comment')),
)

CANDIDATE_COST_TYPES = CANDIDATE_COST_TYPES_MONEY + CANDIDATE_COST_TYPES_SHARE + CANDIDATE_COST_TYPES_COMMENT

CANDIDATE_COST_RATES = Choices(
    ('onetime', _('canidate.cost.rate.onetime')),
    ('hourly', _('canidate.cost.rate.hourly')),
    ('weekly', _('canidate.cost.rate.weekly')),
    ('monthly', _('canidate.cost.rate.monthly')),
    ('quarterly', _('canidate.cost.rate.quarterly')),
    ('annual', _('canidate.cost.rate.annual')),
)

CANDIDATE_TOUCH_MEDIUMS = Choices(
    ('vacancy_site', _('candidate.touch.vacancy_site')),
    ('landing', _('candidate.touch.landing')),
)
