from django.db.models import Q

from intranet.femida.src.candidates.choices import DUPLICATION_CASE_STATUSES
from intranet.femida.src.candidates.models import DuplicationCase

from .adapters import to_cand_adapter
from .constants import DEFINITELY_DUPLICATE


def create_duplication_cases(candidate, duplicates):
    """
    Обрабатываем потенциальных дубликатов и создаем записи DuplicationCase
    """
    duplicates = list(duplicates)
    cand_ids = [d[0].id for d in duplicates] + [candidate.id]
    cases = list(
        DuplicationCase.unsafe
        .filter(status=DUPLICATION_CASE_STATUSES.new)
        .filter(
            Q(first_candidate_id__in=cand_ids)
            | Q(second_candidate_id__in=cand_ids)
        )
    )
    candidate = to_cand_adapter(candidate)

    for duplicate, similarity, decision in duplicates:
        similar_cand_ids = []
        for case in cases:
            if (case.first_candidate_id in [candidate.id, duplicate.id]
                    or case.second_candidate_id in [candidate.id, duplicate.id]):
                similar_cand_ids.append(case.first_candidate_id)
                similar_cand_ids.append(case.second_candidate_id)
        similar_cand_ids = set(similar_cand_ids)

        # TODO: только если score не больше
        if candidate.id in similar_cand_ids and duplicate.id in similar_cand_ids:
            continue

        DuplicationCase.objects.create(
            first_candidate_id=candidate.id,
            second_candidate_id=duplicate.id,
            is_active=True,
            score=similarity.score,
            is_auto_merge=decision == DEFINITELY_DUPLICATE,
        )
