from typing import List

from intranet.femida.src.core.workflow import WorkflowError


class DuplicateLoginConflictError(Exception):
    """
    Исключение, которое кидается при обнаружении
    потенциальных дублей с разными логинами
    """
    def __init__(self, duplicate):
        self.duplicate = duplicate


class HasDuplicatesError(WorkflowError):

    def __init__(self, duplication_case_ids: List[int]):
        self.message = 'candidate_has_duplicates'
        self.params = {
            'duplication_case_ids': duplication_case_ids,
        }


class MergeConflictError(WorkflowError):
    """
    Ошибка, при которой мерж по какой-то причине невозможен
    """
