from . import constants
from .exceptions import DuplicateLoginConflictError


def base_strategy(similarity):
    """
    Если логин не совпадает, то считаем, что это 100% не дубли.
    Если score >= 2, то возможно дубли.
    Гарантий по базовой стратегии не даем вообще
    """
    if 'login' in similarity.conflict_fields:
        return constants.NOT_DUPLICATE
    if similarity.score >= 2:
        return constants.MAYBE_DUPLICATE
    return constants.NOT_DUPLICATE


def doubtful_strategy(similarity):
    """
    Весьма сомнительная стратегия, которую, пожалуй, стоит удалить.
    Аттачи игнорируем.
    Если ни один контакт не совпал, то не дубли.
    Если совпала фамилия и хотя бы один контакт, то точно дубль.
    Если совпало больше двух контактов, то точно дубль.
    Иначе возможно дубль.
    """
    m = similarity.match_details
    if m['contacts'] < 1 or 'login' in similarity.conflict_fields:
        return constants.NOT_DUPLICATE
    if m['last_name'] and m['contacts'] > 0 or m['contacts'] > 2:
        return constants.DEFINITELY_DUPLICATE
    return constants.MAYBE_DUPLICATE


def new_strategy(similarity):
    """
    Если совпадает хотя бы один контакт, имя и фамилия, то точно дубль. Иначе базовая стратегия.
    """
    m = similarity.match_details
    if m['contacts'] and m['first_name'] and m['last_name']:
        return constants.DEFINITELY_DUPLICATE
    return base_strategy(similarity)


def rotation_strategy(similarity):
    """
    Стратегия для откликов-ротаций.
    Если совпадает логин - точно дубль,
    иначе - точно не дубль
    """
    m = similarity.match_details
    if m.get('login'):
        return constants.DEFINITELY_DUPLICATE
    return constants.NOT_DUPLICATE


def staff_strategy(similarity):
    """
    Стратегия для кандидатов со Стаффа.
    Если находим похожего кандидата с другим логином – сразу кидаем исключение.
    """
    m = similarity.match_details
    result = constants.NOT_DUPLICATE
    if m['contacts'] and m['first_name'] and m['last_name']:
        result = constants.DEFINITELY_DUPLICATE
    elif similarity.score >= 2:
        result = constants.MAYBE_DUPLICATE
    if result != constants.NOT_DUPLICATE and 'login' in similarity.conflict_fields:
        raise DuplicateLoginConflictError(similarity.second_candidate)
    return result
