from django.db.models import Q

from intranet.femida.src.candidates.filters.fields.base import FieldFilter, Condition


class Equal(Condition):

    def q(self):
        if not self.filter.model_candidate_attr:
            return Q(**self.cleaned_data)

        return Q(pk__in=(
            self.filter.get_queryset()
            .filter(**self.cleaned_data)
            .values(self.filter.model_candidate_attr)
        ))


class NotEqual(Equal):

    def q(self):
        return ~super().q()


class EqualFilter(FieldFilter):

    condition_classes = [Equal, NotEqual]
