from django.db.models import F


class LastMixin:
    """
    Миксин для получения последних сущностей, связанных с кандидатом:
    последнего образования, последнего работодателя, и т.п.
    Какая из сущностей - последняя, определяется сортировкой по order_field с NULLS FIRST.
    Чтобы запрос получался эффективным, должен быть индекс на (model_candidate_attr, -order_field).
    """
    order_field = 'end_date'

    @classmethod
    def get_queryset(cls):
        queryset = super().get_queryset()
        last_qs = (
            cls.model_class.objects
            .order_by(
                cls.model_candidate_attr,
                F(cls.order_field).desc(nulls_first=True),
            )
            .distinct(cls.model_candidate_attr)
            .values('id')
        )
        return queryset.filter(id__in=last_qs)
