from django.db.models import Q
from django.utils.decorators import classproperty

from intranet.femida.src.candidates.filters.fields.base import Condition, FieldFilter


class Any(Condition):

    def get_model_filter_query(self):
        return Q(**{f'{self.filter.model_value_attr}__in': self.cleaned_data['values']})

    def q(self):
        return Q(pk__in=(
            self.filter.get_queryset()
            .filter(self.get_model_filter_query())
            .values(self.filter.model_candidate_attr)
        ))


class All(Condition):

    def get_lookup(self):
        return ''

    def q(self):
        q = Q()
        lookup = self.get_lookup()
        for value in self.cleaned_data['values']:
            filter_q = Q(**{f'{self.filter.model_value_attr}{lookup}': value})
            q &= Q(pk__in=(
                self.filter.get_queryset()
                .filter(filter_q)
                .values(self.filter.model_candidate_attr)
            ))
        return q


class NotAny(Any):

    def q(self):
        return ~super().q()


class NotAll(All):

    def q(self):
        return ~super().q()


class MultipleChoiceFilter(FieldFilter):

    condition_classes = [Any, All, NotAny, NotAll]
    values_field = None

    @classproperty
    def form_fields(cls):
        assert cls.values_field
        return {'values': cls.values_field}
