import sform

from django.utils.decorators import classproperty

from intranet.femida.src.api.core.validators import validate_at_least_one_filled
from intranet.femida.src.candidates.filters.fields.base import FieldFilter
from intranet.femida.src.candidates.filters.fields.base.equal import Equal
from intranet.femida.src.core.exceptions import SimpleValidationError


class Range(Equal):
    pass


class RangeForm(sform.SForm):

    @classmethod
    def clean_bound_fields(cls, cleaned_data, lower_field, upper_field,
                           is_at_least_one_bound_required=True):
        if is_at_least_one_bound_required:
            validate_at_least_one_filled(
                data=cleaned_data,
                fields=(lower_field, upper_field),
            )
        lower = cleaned_data.get(lower_field)
        upper = cleaned_data.get(upper_field)
        if lower is not None and upper is not None and lower > upper:
            raise SimpleValidationError('bound_ordering')

        for field in (lower_field, upper_field):
            if cleaned_data.get(field) is None:
                cleaned_data.pop(field, None)
        return cleaned_data


class DateRangeForm(sform.SForm):

    def clean(self):
        cleaned_data = super().clean()
        cleaned_data = RangeForm.clean_bound_fields(
            cleaned_data=cleaned_data,
            lower_field=self.lower_field,
            upper_field=self.upper_field,
            is_at_least_one_bound_required=True,
        )
        return cleaned_data


class DateRangeFilter(FieldFilter):

    condition_classes = [Range]
    form_base = DateRangeForm
    date_field = None

    @classproperty
    def form_fields(cls):
        assert cls.date_field
        return {
            f'{cls.date_field}__gte': sform.DateField(),
            f'{cls.date_field}__lte': sform.DateField(),
            'lower_field': f'{cls.date_field}__gte',
            'upper_field': f'{cls.date_field}__lte',
        }
