import sform

from django.db.models import Q

from intranet.femida.src.candidates.filters.fields.base import FieldFilter
from intranet.femida.src.candidates.filters.fields.base.multiple import (
    Any as BaseAny,
    All as BaseAll,
)


class Any(BaseAny):

    def get_model_filter_query(self):
        q = Q()
        for value in self.cleaned_data['values']:
            q |= Q(**{f'{self.filter.model_value_attr}__icontains': value})
        return q


class Contains(BaseAny):

    def get_model_filter_query(self):
        if self.cleaned_data.get('values'):
            value = self.cleaned_data['values'][0]
        else:
            value = self.cleaned_data['value']
        return Q(**{f'{self.filter.model_value_attr}__icontains': value})


class All(BaseAll):

    def get_lookup(self):
        return '__icontains'


class NotAny(Any):

    def q(self):
        return ~super().q()


class NotAll(All):

    def q(self):
        return ~super().q()


class TextFilter(FieldFilter):

    condition_classes = [Any, All, NotAny, NotAll]
    form_fields = {
        'values': sform.GridField(sform.CharField(), state=sform.REQUIRED),
    }
