from django.db.models import Q, Avg, Min, Max

from intranet.femida.src.candidates.filters.fields.base import Condition
from intranet.femida.src.utils.common import get_partial_dict


def _get_interviews_qs(condition):
    return (
        condition.filter
        .get_queryset()
        .filter(**get_partial_dict(
            dictionary=condition.cleaned_data,
            keys=('finished__gte', 'finished__lte', 'aa_type'),
        ))
        .values('candidate_id')
        .annotate(
            min_grade=Min('grade'),
            max_grade=Max('grade'),
            avg_grade=Avg('grade'),
        )
    )


class WithoutNoHire(Condition):

    def q(self):
        interviews_qs = _get_interviews_qs(self).exclude(min_grade=0)
        return Q(pk__in=interviews_qs.values('candidate_id'))


class AllNoHire(Condition):

    def q(self):
        interviews_qs = _get_interviews_qs(self).filter(max_grade=0)
        return Q(pk__in=interviews_qs.values('candidate_id'))


class GradeRange(Condition):

    def q(self):
        interviews_qs = (
            _get_interviews_qs(self)
            .filter(**get_partial_dict(
                dictionary=self.cleaned_data,
                keys=('avg_grade__gte', 'avg_grade__lte'),
            ))
        )
        return Q(pk__in=interviews_qs.values('candidate_id'))
