import sform

from intranet.femida.src.api.core.forms import EMPTY_LABEL
from intranet.femida.src.candidates.filters.fields.base.range import RangeForm
from intranet.femida.src.interviews.choices import INTERVIEW_HIRE_GRADES, AA_TYPES


class InterviewGradeBaseFilterForm(sform.SForm):

    avg_grade__gte = sform.ChoiceField(choices=INTERVIEW_HIRE_GRADES, empty_label=EMPTY_LABEL)
    avg_grade__lte = sform.ChoiceField(choices=INTERVIEW_HIRE_GRADES, empty_label=EMPTY_LABEL)
    finished__gte = sform.DateField()
    finished__lte = sform.DateField()

    def clean_avg_grade__gte(self, value):
        return int(value) if value != '' else None

    def clean_avg_grade__lte(self, value):
        return int(value) if value != '' else None

    def clean(self):
        cleaned_data = super().clean()
        cleaned_data = RangeForm.clean_bound_fields(
            cleaned_data=cleaned_data,
            lower_field='finished__gte',
            upper_field='finished__lte',
            is_at_least_one_bound_required=False,
        )
        return cleaned_data


class InterviewGradeFilterForm(InterviewGradeBaseFilterForm):

    def clean(self):
        cleaned_data = super().clean()
        cleaned_data = RangeForm.clean_bound_fields(
            cleaned_data=cleaned_data,
            lower_field='avg_grade__gte',
            upper_field='avg_grade__lte',
            is_at_least_one_bound_required=True,
        )
        return cleaned_data


class AAInterviewGradeRangeForm(InterviewGradeFilterForm):

    aa_type = sform.ChoiceField(choices=AA_TYPES, state=sform.REQUIRED)


class AAInterviewNoHireForm(sform.SForm):

    aa_type = sform.ChoiceField(choices=AA_TYPES, state=sform.REQUIRED)
    finished__gte = sform.DateField()
    finished__lte = sform.DateField()

    def clean(self):
        cleaned_data = super().clean()
        cleaned_data = RangeForm.clean_bound_fields(
            cleaned_data=cleaned_data,
            lower_field='finished__gte',
            upper_field='finished__lte',
            is_at_least_one_bound_required=False,
        )
        return cleaned_data
