from intranet.femida.src.candidates.filters.fields.base import register_filter
from intranet.femida.src.candidates.filters.fields.base.mixins import LastMixin
from intranet.femida.src.candidates.filters.fields.base.text import TextFilter, Any, NotAny
from intranet.femida.src.candidates.models import CandidateJob


@register_filter
class CandidateJobEmployerFilter(TextFilter):

    model_class = CandidateJob
    model_value_attr = 'employer'


@register_filter
class CandidateJobPositionFilter(TextFilter):

    model_class = CandidateJob
    model_value_attr = 'position'


@register_filter
class LastCandidateJobEmployerFilter(LastMixin, TextFilter):

    model_class = CandidateJob
    model_value_attr = 'employer'
    condition_classes = [Any, NotAny]


@register_filter
class LastCandidateJobPositionFilter(LastMixin, TextFilter):

    model_class = CandidateJob
    model_value_attr = 'position'
    condition_classes = [Any, NotAny]
