import sform

from intranet.femida.src.api.core.forms import TagMultipleSuggestField
from intranet.femida.src.candidates.filters.fields.base import register_filter
from intranet.femida.src.candidates.filters.fields.base.multiple import MultipleChoiceFilter
from intranet.femida.src.candidates.models import CandidateTag


@register_filter
class TagFilter(MultipleChoiceFilter):

    model_class = CandidateTag
    model_value_attr = 'tag'
    values_field = TagMultipleSuggestField(state=sform.REQUIRED)

    @classmethod
    def get_queryset(cls):
        return cls.model_class.objects.filter(is_active=True)
