from django.core.management.base import BaseCommand

from intranet.femida.src.candidates.bulk_upload.choices import CANDIDATE_UPLOAD_MODES
from intranet.femida.src.candidates.bulk_upload.exceptions import InvalidFileExtension
from intranet.femida.src.candidates.bulk_upload.uploaders import CandidateSheetUploader


class Command(BaseCommand):

    help = 'Upload candidates from sheet (xls/csv)'

    def add_arguments(self, parser):
        parser.add_argument('--dry-run', action='store_true')
        parser.add_argument(
            '--mode',
            action='store',
            default=CANDIDATE_UPLOAD_MODES.auto,
            choices=CANDIDATE_UPLOAD_MODES,
        )
        parser.add_argument('--input', '-i', action='store', required=True)
        parser.add_argument('--output', '-o', action='store', default='result.xls')
        parser.add_argument(
            '--data',
            nargs='+',
            action='store',
            default=[],
            help=(
                'You can define common data for all candidates using this option. '
                'Example: --data column1_name=value1 column2_name=value2'
            )
        )

    def handle(self, *args, **options):
        data = dict(i.split('=') for i in options['data'])
        # У --dry-run приоритет над --mode. Это привычное поведение для данной команды
        mode = CANDIDATE_UPLOAD_MODES.check if options['dry_run'] else options['mode']
        try:
            uploader = CandidateSheetUploader(
                input_file_name=options['input'],
                output_file_name=options['output'],
                mode=mode,
                default_data=data,
            )
        except InvalidFileExtension as exc:
            self.stderr.write(exc.message)
            return

        uploader.upload(print_progress=True)
