# Generated by Django 1.11.2 on 2018-08-20 19:08
import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.wf.models
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Candidate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('talent_pool_rate', models.IntegerField(blank=True, null=True)),
                ('source', models.CharField(blank=True, choices=[('internal_reference', 'offer.source.internal_reference'), ('external_reference', 'offer.source.external_reference'), ('rotation', 'offer.source.rotation'), ('found_by_hiring_manager', 'offer.source.found_by_hiring_manager'), ('academic_project', 'offer.source.academic_project'), ('expert_evaluation', 'offer.source.expert_evaluation'), ('candidates_list', 'offer.source.candidates_list'), ('agency', 'offer.source.agency'), ('implant', 'offer.source.implant'), ('yandex_job_website', 'offer.source.yandex_job_website'), ('candidates_base', 'offer.source.candidates_base'), ('external_website', 'offer.source.external_website'), ('internal_event', 'offer.source.internal_event'), ('external_event', 'offer.source.external_event'), ('networking', 'offer.source.networking'), ('other', 'offer.source.other')], default='other', max_length=32)),
                ('source_description', models.CharField(blank=True, max_length=255)),
                ('modified', model_utils.fields.AutoLastModifiedField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('full_name', models.CharField(blank=True, default='', max_length=255)),
                ('login', models.CharField(blank=True, default='', max_length=64)),
                ('startrek_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
                ('first_name', models.CharField(max_length=255)),
                ('middle_name', models.CharField(blank=True, max_length=255)),
                ('last_name', models.CharField(max_length=255)),
                ('birthday', models.DateField(blank=True, null=True)),
                ('gender', models.CharField(blank=True, choices=[('male', 'gender.male'), ('female', 'gender.female')], max_length=6, null=True)),
                ('country', models.CharField(blank=True, max_length=255)),
                ('city', models.CharField(blank=True, max_length=255)),
                ('status', models.CharField(choices=[('in_progress', 'candidate.status.in_progress'), ('closed', 'candidate.status.closed')], default='in_progress', max_length=32)),
                ('is_from_submission', models.BooleanField(default=True)),
                ('is_duplicate', models.BooleanField(default=False)),
                ('is_hidden', models.BooleanField(default=False)),
                ('oebs_person_id', models.IntegerField(blank=True, null=True)),
                ('is_locked', models.BooleanField(default=False)),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='CandidateAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(choices=[('resume', 'candidate.attachment_type.resume')], max_length=255)),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='CandidateCity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
            ],
        ),
        migrations.CreateModel(
            name='CandidateContact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(
                    choices=[
                        ('skype', 'candidate.contact_type.skype'),
                        ('phone', 'candidate.contact_type.phone'),
                        ('email', 'candidate.contact_type.email'),
                        ('hh', 'candidate.contact_type.hh'),
                        ('ah', 'candidate.contact_type.ah'),
                        ('linkedin', 'candidate.contact_type.linkedin'),
                        ('telegram', 'candidate.contact_type.telegram'),
                        ('facebook', 'candidate.contact_type.facebook'),
                        ('vk', 'candidate.contact_type.vk'),
                        ('github', 'candidate.contact_type.github'),
                        ('behance', 'candidate.contact_type.behance'),
                        ('dribbble', 'candidate.contact_type.dribbble'),
                        ('beamery', 'candidate.contact_type.beamery'),
                        ('other', 'candidate.contact_type.other'),
                    ],
                    max_length=32,
                )),
                ('account_id', models.CharField(max_length=255)),
                ('normalized_account_id', models.CharField(blank=True, default='', max_length=255)),
                ('is_main', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('source', models.CharField(blank=True, choices=[('separator', 'candidate.contact_source.separator'), ('forms', 'candidate.contact_source.forms'), ('staff', 'candidate.contact_source.staff'), ('other', 'candidate.contact_source.other')], default='other', max_length=32)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CandidateEducation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('institution', models.CharField(max_length=255)),
                ('faculty', models.CharField(blank=True, max_length=255)),
                ('degree', models.CharField(choices=[('unknown', 'candidate.degree.unknown'), ('studying', 'candidate.degree.studying'), ('not_finished', 'candidate.degree.not_finished'), ('bachelor', 'candidate.degree.bachelor'), ('masters', 'candidate.degree.masters'), ('specialist', 'candidate.degree.specialist')], default='unknown', max_length=32)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('comment', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CandidateJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('employer', models.CharField(max_length=255)),
                ('position', models.CharField(blank=True, max_length=255)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('salary_evaluation', models.CharField(blank=True, max_length=255)),
                ('currency', models.CharField(blank=True, max_length=3)),
                ('comment', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CandidateProfession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('salary_expectation', models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='CandidateSkill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('confirmed_by', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), blank=True, size=None)),
            ],
        ),
        migrations.CreateModel(
            name='CandidateSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('publication_url', models.CharField(blank=True, default='', max_length=255, null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('draft', 'submission.status.draft'),
                            ('new', 'submission.status.new'),
                            ('closed', 'submission.status.closed'),
                        ],
                        default='new',
                        max_length=32,
                    ),
                ),
                ('forms_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('closed_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='CandidateTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
            ],
        ),
        migrations.CreateModel(
            name='Challenge',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('type', models.CharField(choices=[('quiz', 'challenge.type.quiz'), ('contest', 'challenge.type.contest')], default='quiz', max_length=32)),
                ('status', models.CharField(choices=[('assigned', 'challenge.status.assinged'), ('pending_review', 'challenge.status.pending_review'), ('finished', 'challenge.status.finished'), ('cancelled', 'challenge.status.cancelled')], default='assigned', max_length=32)),
                ('resolution', models.CharField(blank=True, choices=[('hire', 'challenge.resolution.hire'), ('nohire', 'challenge.resolution.nohire')], default='', max_length=32, null=True)),
                ('comment', models.TextField(blank=True)),
                ('formatted_comment', models.TextField(blank=True)),
                ('answers', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('finished', models.DateTimeField(blank=True, null=True)),
                ('cancel_reason', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(intranet.femida.src.wf.models.WFModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Consideration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('talent_pool_rate', models.IntegerField(blank=True, null=True)),
                ('source', models.CharField(blank=True, choices=[('internal_reference', 'offer.source.internal_reference'), ('external_reference', 'offer.source.external_reference'), ('rotation', 'offer.source.rotation'), ('found_by_hiring_manager', 'offer.source.found_by_hiring_manager'), ('academic_project', 'offer.source.academic_project'), ('expert_evaluation', 'offer.source.expert_evaluation'), ('candidates_list', 'offer.source.candidates_list'), ('agency', 'offer.source.agency'), ('implant', 'offer.source.implant'), ('yandex_job_website', 'offer.source.yandex_job_website'), ('candidates_base', 'offer.source.candidates_base'), ('external_website', 'offer.source.external_website'), ('internal_event', 'offer.source.internal_event'), ('external_event', 'offer.source.external_event'), ('networking', 'offer.source.networking'), ('other', 'offer.source.other')], default='other', max_length=32)),
                ('source_description', models.CharField(blank=True, max_length=255)),
                ('state', models.CharField(choices=[('in_progress', '\u0412 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0435'), ('archived', '\u0412 \u0430\u0440\u0445\u0438\u0432\u0435')], default='in_progress', max_length=32)),
                ('extended_status', models.CharField(blank=True, choices=[
                    ('in_progress', 'consideration.status.in_progress'),
                    ('challenge_assigned', 'consideration.status.challenge_assigned'),
                    ('challenge_pending_review', 'consideration.status.challenge_pending_review'),
                    ('challenge_finished', 'consideration.status.challenge_finished'),
                    ('hr_screening_assigned', 'consideration.status.hr_screening_assigned'),
                    ('hr_screening_finished', 'consideration.status.hr_screening_finished'),
                    ('screening_assigned', 'consideration.status.screening_assigned'),
                    ('screening_finished', 'consideration.status.screening_finished'),
                    ('interview_assigned', 'consideration.status.interview_assigned'),
                    ('interview_finished', 'consideration.status.interview_finished'),
                    ('final_assigned', 'consideration.status.final_assigned'),
                    ('final_finished', 'consideration.status.final_finished'),
                    ('offer_preparing', 'consideration.status.offer_preparing'),
                    ('offer_on_approval', 'consideration.status.offer_on_approval'),
                    ('offer_sent', 'consideration.status.offer_sent'),
                    ('offer_accepted', 'consideration.status.offer_accepted'),
                    ('archived', 'consideration.status.archived'),
                ], default='in_progress', max_length=32, null=True)),
                (
                    'resolution',
                    models.CharField(
                        blank=True,
                        choices=[
                            ('rejected_by_resume', 'consideration.resolution.rejected_by_resume'),
                            ('rejected_after_test_task', 'consideration.resolution.rejected_after_test_task'),
                            ('rejected_after_screening', 'consideration.resolution.rejected_after_screening'),
                            ('rejected_after_preliminary_interview', 'consideration.resolution.rejected_after_preliminary_interview'),
                            ('rejected_after_onsite_interview', 'consideration.resolution.rejected_after_onsite_interview'),
                            ('rejected_after_final_interview', 'consideration.resolution.rejected_after_final_interview'),
                            ('refused_did_not_respond', 'consideration.resolution.refused_did_not_respond'),
                            ('refused_after_vacancy_proposal', 'consideration.resolution.refused_after_vacancy_proposal'),
                            ('refused_after_test_task', 'consideration.resolution.refused_after_test_task'),
                            ('refused_after_screening', 'consideration.resolution.refused_after_screening'),
                            ('refused_after_preliminary_interview', 'consideration.resolution.refused_after_preliminary_interview'),
                            ('refused_after_onsite_interview', 'consideration.resolution.refused_after_onsite_interview'),
                            ('refused_after_final_interview', 'consideration.resolution.refused_after_final_interview'),
                            ('duplicate', 'consideration.resolution.duplicate'),
                            ('no_offer', 'consideration.resolution.no_offer'),
                            ('offer_rejected', 'consideration.resolution.offer_rejected'),
                            ('offer_accepted', 'consideration.resolution.offer_accepted'),
                            ('vacancy_closed', 'consideration.resolution.vacancy_closed'),
                            ('rotated', 'consideration.resolution.rotated'),
                        ],
                        default='',
                        max_length=64,
                    )
                ),
                ('is_rotation', models.NullBooleanField()),
                ('started', models.DateTimeField(default=django.utils.timezone.now)),
                ('finished', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='ConsiderationHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[
                    ('in_progress', 'consideration.status.in_progress'),
                    ('challenge_assigned', 'consideration.status.challenge_assigned'),
                    ('challenge_pending_review', 'consideration.status.challenge_pending_review'),
                    ('challenge_finished', 'consideration.status.challenge_finished'),
                    ('hr_screening_assigned', 'consideration.status.hr_screening_assigned'),
                    ('hr_screening_finished', 'consideration.status.hr_screening_finished'),
                    ('screening_assigned', 'consideration.status.screening_assigned'),
                    ('screening_finished', 'consideration.status.screening_finished'),
                    ('interview_assigned', 'consideration.status.interview_assigned'),
                    ('interview_finished', 'consideration.status.interview_finished'),
                    ('final_assigned', 'consideration.status.final_assigned'),
                    ('final_finished', 'consideration.status.final_finished'),
                    ('offer_preparing', 'consideration.status.offer_preparing'),
                    ('offer_on_approval', 'consideration.status.offer_on_approval'),
                    ('offer_sent', 'consideration.status.offer_sent'),
                    ('offer_accepted', 'consideration.status.offer_accepted'),
                    ('archived', 'consideration.status.archived'),
                ], max_length=32)),
                ('changed_at', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='CryptaVector',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('yandexuid', models.CharField(max_length=20)),
                ('vector_b', models.BinaryField()),
                ('vector_m', models.BinaryField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DuplicationCase',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_active', models.BooleanField(default=True)),
                ('status', models.CharField(choices=[('new', 'duplication_case.status.new'), ('closed', 'duplication_case.status.closed')], default='new', max_length=32)),
                ('resolution', models.CharField(blank=True, choices=[('duplicate', 'duplication_case.resolution.duplicate'), ('not_duplicate', 'duplication_case.resolution.not_duplicate'), ('unclear', 'duplication_case.resolution.unclear')], max_length=32, null=True)),
                ('score', models.FloatField(blank=True, null=True)),
                ('is_auto_merge', models.BooleanField(default=False)),
                ('first_candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='candidates.Candidate')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
    ]
