# Generated by Django 1.11.2 on 2018-08-20 19:08
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('vacancies', '0001_initial'),
        ('professions', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('candidates', '0001_initial'),
        ('skills', '0001_initial'),
        ('attachments', '0002_attachment_uploader'),
        ('interviews', '0001_initial'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='duplicationcase',
            name='managed_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='duplication_cases', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='duplicationcase',
            name='merged_to',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='duplicationcase',
            name='second_candidate',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='duplicationcase',
            name='submission',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='duplication_cases', to='candidates.CandidateSubmission'),
        ),
        migrations.AddField(
            model_name='cryptavector',
            name='submission',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='crypta_vectors', to='candidates.CandidateSubmission'),
        ),
        migrations.AddField(
            model_name='considerationhistory',
            name='consideration',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='consideration_history', to='candidates.Consideration'),
        ),
        migrations.AddField(
            model_name='consideration',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='considerations', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='consideration',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='created_considerations', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='consideration',
            name='responsibles',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='challenge',
            name='application',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='challenges', to='interviews.Application'),
        ),
        migrations.AddField(
            model_name='challenge',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='challenges', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='challenge',
            name='consideration',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='challenges', to='candidates.Consideration'),
        ),
        migrations.AddField(
            model_name='challenge',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='created_challenges', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='challenge',
            name='finished_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='finished_challenges', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='challenge',
            name='reviewed_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='reviewed_challenges', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='challenge',
            name='submission',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='challenges', to='candidates.CandidateSubmission'),
        ),
        migrations.AddField(
            model_name='candidatetag',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_tags', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidatetag',
            name='tag',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_tags', to='core.Tag'),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='attachment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='submissions', to='attachments.Attachment'),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='candidate',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='submissions', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='submissions', to='vacancies.SubmissionForm'),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='responsible',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='submissions_responsible_for', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='vacancies',
            field=models.ManyToManyField(blank=True, related_name='submissions', to='vacancies.Vacancy'),
        ),
        migrations.AddField(
            model_name='candidateskill',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_skills', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidateskill',
            name='skill',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_skills', to='skills.Skill'),
        ),
        migrations.AddField(
            model_name='candidateprofession',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_professions', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidateprofession',
            name='profession',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_professions', to='professions.Profession'),
        ),
        migrations.AddField(
            model_name='candidateprofession',
            name='professional_sphere',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='candidate_professions', to='professions.ProfessionalSphere'),
        ),
        migrations.AddField(
            model_name='candidatejob',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='jobs', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidateeducation',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='educations', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidatecontact',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='contacts', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidatecity',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_cities', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidatecity',
            name='city',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_cities', to='core.City'),
        ),
        migrations.AddField(
            model_name='candidateattachment',
            name='application',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='candidate_attachments', to='interviews.Application'),
        ),
        migrations.AddField(
            model_name='candidateattachment',
            name='attachment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_attachments', to='attachments.Attachment'),
        ),
        migrations.AddField(
            model_name='candidateattachment',
            name='candidate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='candidate_attachments', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='candidate',
            name='original',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='duplicates', to='candidates.Candidate'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='responsibles',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='candidate',
            name='tags',
            field=models.ManyToManyField(related_name='candidates', through='candidates.CandidateTag', to='core.Tag'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='target_cities',
            field=models.ManyToManyField(related_name='candidates', through='candidates.CandidateCity', to='core.City'),
        ),
        migrations.AddField(
            model_name='candidate',
            name='attachments',
            field=models.ManyToManyField(
                related_name='candidates',
                through='candidates.CandidateAttachment',
                to='attachments.Attachment',
            ),
        ),
        migrations.AddField(
            model_name='candidate',
            name='skills',
            field=models.ManyToManyField(
                related_name='candidates',
                through='candidates.CandidateSkill',
                to='skills.Skill',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='candidatetag',
            unique_together=set([('candidate', 'tag')]),
        ),
        migrations.AlterUniqueTogether(
            name='candidateskill',
            unique_together=set([('candidate', 'skill')]),
        ),
        migrations.AlterUniqueTogether(
            name='candidateprofession',
            unique_together=set([('candidate', 'profession')]),
        ),
        migrations.AlterUniqueTogether(
            name='candidatecity',
            unique_together=set([('candidate', 'city')]),
        ),
    ]
