# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-03-06 12:43
from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.utils.datetime
import functools
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('candidates', '0003_crypta_vector'),
    ]

    operations = [
        migrations.CreateModel(
            name='Reference',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('startrek_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(max_length=32)),
                ('status', models.CharField(
                    choices=[
                        ('new', 'reference.status.new'),
                        ('approved', 'reference.status.approved'),
                        ('approved_without_benefits', 'reference.status.approved_without_benefits'),
                        ('rejected', 'reference.status.rejected'),
                    ],
                    default='new',
                    max_length=32,
                )),
                ('expiration_date', models.DateTimeField(default=functools.partial(intranet.femida.src.utils.datetime.shifted_now, *(), **{'months': 6}))),
                ('processed_at', models.DateTimeField(blank=True, null=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_references', to=settings.AUTH_USER_MODEL)),
                ('processed_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='processed_references', to=settings.AUTH_USER_MODEL, blank=True, null=True)),
                ('vacancies', models.ManyToManyField(blank=True, related_name='references', to='vacancies.Vacancy')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='reference',
            field=models.OneToOneField(null=True, blank=True, on_delete=django.db.models.deletion.PROTECT, related_name='submission', to='candidates.Reference'),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='comment',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='email',
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='first_name',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='last_name',
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='phone',
            field=models.CharField(blank=True, max_length=64, null=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='professions',
            field=models.ManyToManyField(related_name='submissions', to='professions.Profession', blank=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='skills',
            field=models.ManyToManyField(related_name='submissions', to='skills.Skill', blank=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='target_cities',
            field=models.ManyToManyField(related_name='submissions', to='core.City', blank=True),
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='source',
            field=models.CharField(
                choices=[
                    ('form', 'submission.source.form'),
                    ('reference', 'submission.source.reference'),
                    ('rotation', 'submission.source.rotation'),
                ],
                max_length=32,
                null=True,
                default='form',
            ),
        ),
    ]
