# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-05-28 13:09
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import intranet.femida.src.core.db.fields
import intranet.femida.src.utils.datetime
import functools
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('candidates', '0007_make_startrek_issue_key_nullable'),
    ]

    operations = [
        migrations.CreateModel(
            name='Rotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('startrek_rotation_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(max_length=32)),
                ('startrek_myrotation_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(max_length=32)),
                ('status', models.CharField(
                    choices=[
                        ('new', 'rotation.status.new'),
                        ('approved', 'rotation.status.approved'),
                        ('rejected', 'rotation.status.rejected'),
                    ],
                    default='new',
                    max_length=32,
                )),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='created_rotations', to=settings.AUTH_USER_MODEL)),
                ('vacancies', models.ManyToManyField(related_name='rotations', to='vacancies.Vacancy')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='candidatesubmission',
            name='rotation',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='submission', to='candidates.Rotation'),
        ),
    ]
